<?php
// admin/dashboard.php
session_start();
require_once __DIR__ . '/../includes/db.php';

// Admin oturum kontrolü
if (empty($_SESSION['admin_user'])) {
    header('Location: login.php');
    exit;
}

$db = DB::get();

// Basit istatistikler
// Toplam portal kullanıcısı
$totalUsers = (int)$db->query("SELECT COUNT(*) FROM portal_users")->fetchColumn();

// Evren istatistikleri (portal_universes tablosundan)
try {
    $totalUniverses = (int)$db->query("SELECT COUNT(*) FROM portal_universes")->fetchColumn();
    $activeUniverses = (int)$db->query("SELECT COUNT(*) FROM portal_universes WHERE status = 'active'")->fetchColumn();
    $soonUniverses   = (int)$db->query("SELECT COUNT(*) FROM portal_universes WHERE status = 'soon'")->fetchColumn();
} catch (Exception $e) {
    $totalUniverses  = 0;
    $activeUniverses = 0;
    $soonUniverses   = 0;
}

// Son kayıt olan 5 kullanıcı (id'ye göre)
$lastUsersStmt = $db->query("SELECT id, username, email FROM portal_users ORDER BY id DESC LIMIT 5");
$lastUsers     = $lastUsersStmt->fetchAll();

// Oturumdaki admin
$admin = $_SESSION['admin_user'];
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <title>Novapus Admin · Dashboard</title>
    <link rel="stylesheet" href="assets/admin.css">
</head>
<body class="admin-shell">

    <!-- Sol Menü -->
    <aside class="admin-sidebar">
        <div class="admin-sidebar-logo">
            <span class="asl-title">NOVAPUS</span>
            <span class="asl-sub">ADMIN PANEL</span>
        </div>

        <nav class="admin-menu">
            <a href="dashboard.php" class="am-item active">
                <span class="am-icon">🏠</span>
                <span>Genel Bakış</span>
            </a>
            <a href="#" class="am-item">
                <span class="am-icon">👤</span>
                <span>Kullanıcılar</span>
            </a>
            <a href="#" class="am-item">
                <span class="am-icon">🪐</span>
                <span>Evrenler</span>
            </a>
            <a href="#" class="am-item">
                <span class="am-icon">📨</span>
                <span>İletişim Mesajları</span>
            </a>
            <a href="#" class="am-item">
                <span class="am-icon">⚙️</span>
                <span>Portal Ayarları</span>
            </a>
        </nav>

        <div class="admin-sidebar-footer">
            <a href="../index.php" class="am-item am-mini">
                <span class="am-icon">🌌</span>
                <span>Portala Dön</span>
            </a>
            <a href="logout.php" class="am-item am-mini">
                <span class="am-icon">⏏</span>
                <span>Çıkış</span>
            </a>
        </div>
    </aside>

    <!-- Sağ Ana Alan -->
    <div class="admin-main">

        <!-- Üst Bar -->
        <header class="admin-topbar">
            <div class="at-title">
                <h1>Dashboard</h1>
                <span>Novapus galaktik portal durumu</span>
            </div>

            <div class="at-user">
                <div class="at-user-info">
                    <span class="at-user-label">Admin</span>
                    <span class="at-user-name"><?= htmlspecialchars($admin['username']); ?></span>
                </div>
                <div class="at-user-avatar">
                    <!-- İstersen buraya özel admin avatarı koyarız -->
                    <span>A</span>
                </div>
            </div>
        </header>

        <!-- İçerik -->
        <main class="admin-content">

            <!-- Stat Kartları -->
            <section class="admin-stats-grid">

                <div class="admin-stat-card asc-blue">
                    <div class="asc-label">Toplam Kullanıcı</div>
                    <div class="asc-value"><?= number_format($totalUsers, 0, ',', '.'); ?></div>
                    <div class="asc-sub">Portal hesabı açmış komutan sayısı</div>
                </div>

                <div class="admin-stat-card asc-green">
                    <div class="asc-label">Aktif Evren</div>
                    <div class="asc-value"><?= $activeUniverses; ?></div>
                    <div class="asc-sub">Şu anda oyunculara açık evren sayısı</div>
                </div>

                <div class="admin-stat-card asc-yellow">
                    <div class="asc-label">Yakında Açılacak</div>
                    <div class="asc-value"><?= $soonUniverses; ?></div>
                    <div class="asc-sub">Planlanan yeni sezon / evren</div>
                </div>

                <div class="admin-stat-card asc-purple">
                    <div class="asc-label">Toplam Evren Kaydı</div>
                    <div class="asc-value"><?= $totalUniverses; ?></div>
                    <div class="asc-sub">Portal yapılandırmasına kayıtlı evren</div>
                </div>

            </section>

            <!-- Alt Grid: Son Kullanıcılar + Not -->
            <section class="admin-lower-grid">

                <div class="admin-panel-card">
                    <div class="apc-header">
                        <h2>Son Kayıt Olan Kullanıcılar</h2>
                        <span class="apc-sub">En son portal hesabı açmış 5 komutan</span>
                    </div>

                    <?php if (empty($lastUsers)): ?>
                        <p>Henüz kayıtlı kullanıcı bulunmuyor.</p>
                    <?php else: ?>
                        <table class="apc-table">
                            <thead>
                                <tr>
                                    <th>ID</th>
                                    <th>Kullanıcı Adı</th>
                                    <th>E-posta</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($lastUsers as $u): ?>
                                    <tr>
                                        <td>#<?= (int)$u['id']; ?></td>
                                        <td><?= htmlspecialchars($u['username']); ?></td>
                                        <td><?= htmlspecialchars($u['email']); ?></td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    <?php endif; ?>
                </div>

                <div class="admin-panel-card apc-note">
                    <div class="apc-header">
                        <h2>Hızlı Notlar</h2>
                        <span class="apc-sub">Portal yapılandırmasını yönetirken kısa özet</span>
                    </div>
                    <ul class="apc-note-list">
                        <li>Evren ekleme / hız değiştirme işlemleri <strong>Evrenler</strong> menüsüne taşınacak.</li>
                        <li>İletişim / destek mesajları burada listelenip yanıtlanabilecek.</li>
                        <li>Tek hesap – çoklu evren mantığı portal kullanıcılarına göre çalışıyor.</li>
                        <li>Gerekirse buraya “bakım modu”, “duyuru bannerı” gibi hızlı anahtarlar ekleyebiliriz.</li>
                    </ul>
                </div>

            </section>

        </main>

    </div>

</body>
</html>