<?php
session_start();
require_once __DIR__ . '/../includes/db.php';
require_once __DIR__ . '/includes/admin_auth.php';

$db    = DB::get();
$admin = $_SESSION['admin_user'];

// Form gönderildiyse
if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    $title   = trim($_POST['title']);
    $slug    = trim($_POST['slug']);
    $type    = $_POST['type'] ?? 'html';
    $content = trim($_POST['content']);
    $visible = isset($_POST['visible']) ? 1 : 0;
    $sort    = (int)($_POST['sort'] ?? 0);

    // Varsayılan resim yolu
    $imagePath = null;

    // Resim yüklendiyse işle
    if (!empty($_FILES['image']['name']) && $_FILES['image']['error'] === UPLOAD_ERR_OK) {

        $ext = strtolower(pathinfo($_FILES['image']['name'], PATHINFO_EXTENSION));

        if (in_array($ext, ['jpg','jpeg','png','gif','webp'])) {

            $uploadDir = __DIR__ . '/../uploads/cms/';
            if (!is_dir($uploadDir)) {
                mkdir($uploadDir, 0777, true);
            }

            $fileName   = 'block_' . time() . '_' . mt_rand(1000,9999) . '.' . $ext;
            $targetPath = $uploadDir . $fileName;

            if (move_uploaded_file($_FILES['image']['tmp_name'], $targetPath)) {
                $imagePath = 'uploads/cms/' . $fileName;
            }
        }
    }

    if ($title !== '' && $slug !== '') {
        $stmt = $db->prepare("
            INSERT INTO portal_cms (title, slug, type, content, image, visible, sort)
            VALUES (?, ?, ?, ?, ?, ?, ?)
        ");
        $stmt->execute([$title, $slug, $type, $content, $imagePath, $visible, $sort]);

        header("Location: portal_pages.php?added=1");
        exit;
    }
}
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <title>Novapus Admin · Yeni CMS Bloğu</title>
    <link rel="stylesheet" href="assets/admin.css">

    <style>
        .edit-container {
            display: flex;
            gap: 25px;
        }
        .edit-left {
            width: 55%;
        }
        .edit-right-preview {
            width: 45%;
            background: #0c0f17;
            border: 1px solid #1f2430;
            border-radius: 10px;
            padding: 20px;
            overflow-y: auto;
            max-height: 85vh;
            box-shadow: inset 0 0 20px rgba(0,0,0,0.35);
        }
        .preview-title {
            font-size: 18px;
            font-weight: 600;
            color: #93c5fd;
            margin-bottom: 10px;
        }
        .preview-box {
            background: #111827;
            border: 1px solid #1f2937;
            padding: 15px;
            border-radius: 8px;
            min-height: 200px;
        }
        .preview-image {
            max-width: 100%;
            border-radius: 6px;
            margin-bottom: 15px;
        }
        .preview-empty {
            color: #6b7280;
            font-style: italic;
        }
    </style>
</head>
<body class="admin-shell">

<?php include __DIR__ . '/includes/sidebar.php'; ?>

<div class="admin-main">

<header class="admin-topbar">
    <div class="at-title">
        <h1>Yeni CMS Bloğu Ekle</h1>
        <span>Portal ana sayfasına yeni bir içerik bölümü ekleyin</span>
    </div>

    <div class="at-user">
        <div class="at-user-info">
            <span class="at-user-label">Admin</span>
            <span class="at-user-name"><?= htmlspecialchars($admin['username']); ?></span>
        </div>
        <div class="at-user-avatar"><span>A</span></div>
    </div>
</header>

<main class="admin-content">

<div class="edit-container">

    <!-- ========== SOL TARAF: FORM ========== -->
    <div class="edit-left">

        <section class="admin-panel-card">

            <div class="apc-header">
                <h2>Yeni Blok Bilgileri</h2>
                <span class="apc-sub">Tipi seç, içeriği doldur, sağdan canlı önizlemeyi izle.</span>
            </div>

            <form method="post" class="admin-form" enctype="multipart/form-data">

                <label class="admin-label">Blok Tipi</label>
                <select name="type" id="type" class="admin-input">
                    <option value="hero">Kahraman Bölümü (Üst büyük alan)</option>
                    <option value="universes">Evren Listesi (Otomatik)</option>
                    <option value="slider">Slider (Kayan görseller)</option>
                    <option value="banner">Banner (Tek büyük görsel)</option>
                    <option value="text">Metin Bloğu</option>
                    <option value="html">Serbest HTML</option>
                </select>

                <label class="admin-label">Blok Başlığı</label>
                <input type="text" id="title" name="title" class="admin-input"
                       placeholder="Örn: Kahraman Bölümü" required>

                <label class="admin-label">Slug (Benzersiz Anahtar)</label>
                <input type="text" id="slug" name="slug" class="admin-input"
                       placeholder="örn: hero_section" required>

                <label class="admin-label">İçerik</label>
                <textarea id="content" name="content" class="admin-textarea" rows="10"
                          placeholder="HTML içerik yazın..."></textarea>

                <label class="admin-label">Blok Görseli (Opsiyonel)</label>
                <input type="file" id="imageFile" name="image" class="admin-input">

                <label class="admin-label">Sıra (Sort)</label>
                <input type="number" name="sort" class="admin-input" value="1">

                <label class="admin-checkbox">
                    <input type="checkbox" name="visible" checked>
                    <span>Bu blok portalda görünsün</span>
                </label>

                <button class="btn-primary" type="submit">Bloğu Oluştur</button>

            </form>

        </section>

    </div>

    <!-- ========== SAĞ TARAF: CANLI ÖNİZLEME ========== -->
    <div class="edit-right-preview">

        <div class="preview-title">Canlı Önizleme</div>

        <div id="previewBox" class="preview-box">
            <div class="preview-empty">Tip seçip içerik yazdıkça önizleme burada görünecek…</div>
        </div>

    </div>

</div>

</main>

</div>

<!-- CKEditor -->
<script src="https://cdn.ckeditor.com/4.22.1/full/ckeditor.js"></script>
<script>
    CKEDITOR.replace('content', { height: 300 });

    function updatePreview() {
        const type  = document.getElementById('type').value;
        const title = document.getElementById('title').value;
        const slug  = document.getElementById('slug').value;
        const html  = CKEDITOR.instances.content.getData();

        let previewHtml = "";

        switch (type) {
            case "hero":
                previewHtml = `
                    <div style="padding:40px; background:#0f172a; border-radius:10px;">
                        <h1 style="color:#60a5fa">${title || 'Kahraman Başlığı'}</h1>
                        ${html || '<p>Buraya kahraman alanı içeriği gelecek.</p>'}
                    </div>`;
                break;

            case "universes":
                previewHtml = `
                    <div style="padding:20px; background:#1e293b; border-radius:10px;">
                        <h2 style="color:#34d399">Evren Listesi Modülü</h2>
                        <p>Bu blok home.php’de <strong>otomatik evren listesini</strong> çizer. İçerik kısmını
                        açıklama metni için kullanabilirsin.</p>
                        ${html || ''}
                    </div>`;
                break;

            case "slider":
                previewHtml = `
                    <div style="padding:20px; background:#0f172a; border-radius:10px;">
                        <h3 style="color:#a78bfa">Slider Önizleme</h3>
                        ${html || '<p>Buraya slider içeriğini (slide divleri) ekleyebilirsin.</p>'}
                    </div>`;
                break;

            case "banner":
                previewHtml = `
                    <div style="padding:10px; background:#0f172a; border-radius:10px;">
                        <h3 style="color:#facc15">Banner</h3>
                        ${html || '<p>Buraya banner metni veya açıklaması gelecek.</p>'}
                    </div>`;
                break;

            case "text":
                previewHtml = `
                    <div style="padding:20px;">
                        <h3>${title || 'Metin Bloğu Başlığı'}</h3>
                        ${html || '<p>Buraya metin içeriği gelecek.</p>'}
                    </div>`;
                break;

            default:
                previewHtml = html || '<p class="preview-empty">İçeriği yazmaya başlayın…</p>';
        }

        document.getElementById('previewBox').innerHTML = previewHtml;
    }

    // CKEditor değiştikçe
    CKEDITOR.instances.content.on('change', updatePreview);

    // Form alanları değiştikçe
    document.getElementById('type').addEventListener('change', updatePreview);
    document.getElementById('title').addEventListener('input', updatePreview);
    document.getElementById('slug').addEventListener('input', updatePreview);

    // İlk yüklemede boş state
    setTimeout(updatePreview, 500);
</script>

</body>
</html>
