<?php
// admin/profile_changes.php
session_start();
require_once __DIR__ . '/../includes/db.php';
require_once __DIR__ . '/includes/admin_auth.php';

$db    = DB::get();
$admin = $_SESSION['admin_user'] ?? null;

/* ===========================
   AVATAR PATH DÜZENLEYİCİ
=========================== */
function resolveAvatarPath($value) {

    $value = trim($value);

    if ($value === "" || $value === null) {
        return "/portal/assets/img/default-avatar.png";
    }

    // Tam URL ise direkt kullan
    if (str_starts_with($value, "http")) {
        return $value;
    }

    // uploads klasörü
    if (str_starts_with($value, "uploads/avatars/")) {
        return "/portal/" . $value;
    }

    // assets klasörü
    if (str_starts_with($value, "assets/")) {
        return "/portal/" . $value;
    }

    // Sadece dosya adı verilmişse
    if (!str_contains($value, "/")) {
        return "/portal/assets/uploads/avatars/" . $value;
    }

    // Diğer tüm durumlar
    return "/portal/" . ltrim($value, "/");
}


/* ===========================
   PROFİL DEĞİŞİKLİKLERİNİ ÇEK
=========================== */
$stmt = $db->query("
    SELECT p.*, u.username AS owner_name
    FROM portal_profile_changes p
    LEFT JOIN portal_users u ON u.id = p.user_id
    ORDER BY p.status = 'pending' DESC, p.created_at DESC
");
$changes = $stmt->fetchAll();

?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <title>Novapus Admin · Profil Onayları</title>
    <link rel="stylesheet" href="assets/admin.css">
</head>

<body class="admin-shell">

<?php include __DIR__ . '/includes/sidebar.php'; ?>

<div class="admin-main">

    <!-- ÜST BAR -->
    <header class="admin-topbar">
        <div class="at-title">
            <h1>Profil Değişikliği Onayları</h1>
            <span>Kullanıcı adı, e-posta ve avatar güncellemelerini yönet</span>
        </div>

        <div class="at-user">
            <div class="at-user-info">
                <span class="at-user-label">Admin</span>
                <span class="at-user-name"><?= htmlspecialchars($admin['username'] ?? 'admin'); ?></span>
            </div>
            <div class="at-user-avatar"><span>A</span></div>
        </div>
    </header>

    <!-- İÇERİK -->
    <main class="admin-content">

        <div class="admin-panel-card">

            <div class="apc-header" style="margin-bottom:14px;">
                <h2>Profil Değişikliği Talepleri</h2>
                <div class="apc-sub">
                    Kullanıcılardan gelen kullanıcı adı, e-posta ve avatar değişikliklerini buradan
                    onaylayabilir veya reddedebilirsin.
                </div>
            </div>

            <table class="apc-table">
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Kullanıcı</th>
                        <th>Alan</th>
                        <th>Eski</th>
                        <th>Yeni</th>
                        <th>Durum</th>
                        <th>Tarih</th>
                        <th style="text-align:right;">İşlemler</th>
                    </tr>
                </thead>

                <tbody>

                <?php if (empty($changes)): ?>
                    <tr>
                        <td colspan="8" style="text-align:center; padding:14px; color:#9ca3af;">
                            Henüz herhangi bir profil değişikliği talebi bulunmuyor.
                        </td>
                    </tr>

                <?php else: ?>
                    <?php foreach ($changes as $row): ?>
                        <tr style="<?= $row['status'] === 'pending' ? 'background:rgba(250,204,21,0.10);' : '' ?>">

                            <!-- ID -->
                            <td>#<?= (int)$row['id'] ?></td>

                            <!-- Kullanıcı -->
                            <td><?= htmlspecialchars($row['owner_name'] ?? 'Bilinmiyor'); ?></td>

                            <!-- Alan -->
                            <td>
                                <?php
                                    if ($row['field'] === 'username') echo "Kullanıcı Adı";
                                    elseif ($row['field'] === 'email') echo "E-posta";
                                    else echo "Avatar";
                                ?>
                            </td>

                            <!-- Eski Değer -->
                            <td>
                                <?php if ($row['field'] === 'avatar' && !empty($row['old_value'])): ?>
                                    <img src="<?= resolveAvatarPath($row['old_value']); ?>" class="mini-avatar">
                                <?php else: ?>
                                    <?= htmlspecialchars($row['old_value']); ?>
                                <?php endif; ?>
                            </td>

                            <!-- Yeni Değer -->
                            <td>
                                <?php if ($row['field'] === 'avatar'): ?>
                                    <img src="<?= resolveAvatarPath($row['new_value']); ?>" class="mini-avatar">
                                <?php else: ?>
                                    <?= htmlspecialchars($row['new_value']); ?>
                                <?php endif; ?>
                            </td>

                            <!-- Durum -->
                            <td>
                                <?php if ($row['status'] === 'pending'): ?>
                                    <span style="color:#facc15;font-weight:600;">Bekliyor</span>
                                <?php elseif ($row['status'] === 'approved'): ?>
                                    <span style="color:#4ade80;font-weight:600;">Onaylandı</span>
                                <?php else: ?>
                                    <span style="color:#ef4444;font-weight:600;">Reddedildi</span>
                                <?php endif; ?>
                            </td>

                            <!-- Tarih -->
                            <td><?= htmlspecialchars($row['created_at']); ?></td>

                            <!-- İşlemler -->
                            <td style="text-align:right;">
                                <?php if ($row['status'] === 'pending'): ?>

                                    <form method="post"
                                          action="profile_changes_action.php"
                                          style="display:inline-flex; gap:8px;">
                                        <input type="hidden" name="id" value="<?= (int)$row['id']; ?>">

                                        <button type="submit"
                                                name="approve"
                                                class="btn-admin-small blue">
                                            Onayla
                                        </button>

                                        <button type="button"
                                                onclick="rejectPrompt(<?= (int)$row['id']; ?>)"
                                                class="btn-admin-small red">
                                            Reddet
                                        </button>
                                    </form>

                                <?php else: ?>
                                    <span style="color:#64748b;">—</span>
                                <?php endif; ?>
                            </td>

                        </tr>
                    <?php endforeach; ?>
                <?php endif; ?>

                </tbody>
            </table>

        </div>

    </main>

</div>

<style>
.mini-avatar {
    width: 34px;
    height: 34px;
    border-radius: 8px;
    object-fit: cover;
    box-shadow: 0 0 6px rgba(0,0,0,.35);
}
</style>

<script>
function rejectPrompt(id) {
    const note = prompt("Reddetme sebebi:");
    if (!note) return;

    const form = document.createElement('form');
    form.method = 'post';
    form.action = 'profile_changes_action.php';

    form.innerHTML = `
        <input type="hidden" name="id" value="${id}">
        <input type="hidden" name="reject" value="1">
        <input type="hidden" name="note" value="${note}">
    `;

    document.body.appendChild(form);
    form.submit();
}
</script>

</body>
</html>
