<?php
session_start();
require_once __DIR__ . '/../includes/db.php';
require_once __DIR__ . '/../includes/Logger.php';

if (empty($_SESSION['admin_user'])) {
    header("Location: login.php");
    exit;
}

$db    = DB::get();
$admin = $_SESSION['admin_user'];

$ticketId = isset($_GET['id']) ? (int)$_GET['id'] : 0;

if ($ticketId <= 0) {
    die("Geçersiz ticket ID.");
}

/* ==========================================================
   TICKET DETAY
========================================================== */

$stm = $db->prepare("
    SELECT t.*, u.username, u.email
    FROM portal_tickets t
    LEFT JOIN portal_users u ON t.user_id = u.id
    WHERE t.id = ?
");
$stm->execute([$ticketId]);
$ticket = $stm->fetch();

if (!$ticket) {
    die("Ticket bulunamadı.");
}

/* ==========================================================
   TICKET MESAJLARI
========================================================== */

$msgStmt = $db->prepare("
    SELECT *
    FROM portal_ticket_messages
    WHERE ticket_id = ?
    ORDER BY id ASC
");
$msgStmt->execute([$ticketId]);
$messages = $msgStmt->fetchAll();

/* ==========================================================
   EKLERİ (GÖRSELLER) YÜKLE
========================================================== */

$attStmt = $db->prepare("
    SELECT *
    FROM portal_ticket_attachments
    WHERE ticket_id = ?
    ORDER BY id ASC
");
$attStmt->execute([$ticketId]);
$attachments = $attStmt->fetchAll();

/* ==========================================================
   ADMIN CEVABI
========================================================== */

$message = '';
$success = '';

if (isset($_POST['send_reply'])) {

    $reply = trim($_POST['reply']);

    if ($reply === "") {
        $message = "Cevap boş olamaz.";
    } else {

        $stmt = $db->prepare("
            INSERT INTO portal_ticket_messages (ticket_id, sender, message, created_at)
            VALUES (?, 'admin', ?, NOW())
        ");
        $stmt->execute([$ticketId, $reply]);

        // Ticket durumunu güncelle
        $db->prepare("UPDATE portal_tickets SET status = 'answered', updated_at = NOW() WHERE id = ?")
            ->execute([$ticketId]);

        Logger::write(
            "admin_action",
            "Ticket yanıtlandı (#{$ticketId})",
            $admin['id']
        );

        $success = "Cevap gönderildi.";
    }
}

/* ==========================================================
   TICKET KAPAT
========================================================== */

if (isset($_POST['close_ticket'])) {

    $db->prepare("UPDATE portal_tickets SET status = 'closed', updated_at = NOW() WHERE id = ?")
        ->execute([$ticketId]);

    Logger::write(
        "admin_action",
        "Ticket kapatıldı (#{$ticketId})",
        $admin['id']
    );

    $success = "Ticket kapatıldı.";
}

?>
<!DOCTYPE html>
<html lang="tr">
<head>
<meta charset="UTF-8">
<title>Admin · Ticket #<?= $ticketId ?></title>
<link rel="stylesheet" href="assets/admin.css">
</head>

<body class="admin-shell">

<?php include __DIR__ . '/includes/sidebar.php'; ?>

<div class="admin-main">

<header class="admin-topbar">
    <h1>Ticket #<?= $ticketId ?></h1>
    <span><?= htmlspecialchars($ticket['subject']) ?></span>
</header>

<main class="admin-content">

<?php if ($success): ?>
    <div class="admin-success-box"><?= htmlspecialchars($success) ?></div>
<?php endif; ?>

<?php if ($message): ?>
    <div class="admin-error-box"><?= htmlspecialchars($message) ?></div>
<?php endif; ?>

<!-- ==============================================
     TICKET BİLGİLERİ
================================================= -->
<div class="admin-panel-card">

    <h2>Ticket Bilgileri</h2>

    <p><strong>Kullanıcı:</strong> <?= htmlspecialchars($ticket['username'] ?: 'Bilinmiyor') ?></p>
    <p><strong>E-posta:</strong> <?= htmlspecialchars($ticket['email']) ?></p>
    <p><strong>Durum:</strong>
        <span class="ticket-status <?= $ticket['status'] ?>">
            <?= strtoupper($ticket['status']) ?>
        </span>
    </p>
    <p><strong>Oluşturulma:</strong> <?= $ticket['created_at'] ?></p>
    <p><strong>Güncelleme:</strong> <?= $ticket['updated_at'] ?></p>

</div>

<!-- ==============================================
     EKLER (GÖRSELLER)
================================================= -->
<?php if (!empty($attachments)): ?>
<div class="admin-panel-card">
    <h2>Ekler</h2>

    <div style="display:flex;flex-wrap:wrap;gap:12px;">

        <?php foreach ($attachments as $a): ?>
            <div style="border:1px solid #3b4252;padding:8px;border-radius:8px;">
                <a href="../<?= htmlspecialchars($a['file_path']) ?>" target="_blank">
                    <img src="../<?= htmlspecialchars($a['file_path']) ?>"
                         style="max-width:150px;border-radius:6px;">
                </a>
                <div style="font-size:11px;color:#9ca3af;margin-top:4px;">
                    <?= htmlspecialchars($a['original_name']) ?>
                </div>
            </div>
        <?php endforeach; ?>

    </div>
</div>
<?php endif; ?>

<!-- ==============================================
     MESAJLAR
================================================= -->
<div class="admin-panel-card">
    <h2>Mesajlar</h2>

    <div class="ticket-message-list">

        <?php foreach ($messages as $msg): ?>

            <div class="ticket-msg <?= $msg['sender'] === 'admin' ? 'admin' : 'user' ?>">

                <div class="ticket-msg-header">
                    <strong><?= $msg['sender'] === 'admin' ? 'Admin' : $ticket['username'] ?></strong>
                    <span class="ticket-msg-date"><?= $msg['created_at'] ?></span>
                </div>

                <div class="ticket-msg-body">
                    <?= nl2br(htmlspecialchars($msg['message'])) ?>
                </div>
            </div>

        <?php endforeach; ?>

        <?php if (empty($messages)): ?>
            <p>Bu ticket için mesaj bulunmuyor.</p>
        <?php endif; ?>

    </div>
</div>

<!-- ==============================================
     CEVAP FORMU
================================================= -->

<?php if ($ticket['status'] !== 'closed'): ?>

<div class="admin-panel-card">
    <h2>Admin Cevabı</h2>

    <form action="" method="post">
        <label>Cevabınız
            <textarea name="reply" rows="4"></textarea>
        </label>

        <button name="send_reply" class="admin-btn-save">Gönder</button>
    </form>

    <form action="" method="post" style="margin-top:12px;">
        <button name="close_ticket" class="admin-btn-danger"
                onclick="return confirm('Ticket kapatılsın mı?');">
            Ticketı Kapat
        </button>
    </form>
</div>

<?php else: ?>

<div class="admin-panel-card">
    <h2>Ticket Kapalı</h2>
    <p>Bu ticket kapalı olduğu için yeni mesaj gönderilemez.</p>
</div>

<?php endif; ?>

</main>
</div>
</body>
</html>