<?php
// admin/tickets.php
session_start();
require_once __DIR__ . '/../includes/db.php';
require_once __DIR__ . '/../includes/Logger.php';

if (empty($_SESSION['admin_user'])) {
    header("Location: login.php");
    exit;
}

$db    = DB::get();
$admin = $_SESSION['admin_user'];

// Arama
$search = trim($_GET['s'] ?? "");

// Arama varsa logla
if ($search !== "") {
    Logger::write(
        "admin_action",
        "Ticket araması yapıldı. Aranan: '{$search}'",
        $admin['id']
    );
}

// Ticket silme işlemi
if (isset($_POST['delete_ticket'])) {

    $delId = intval($_POST['ticket_id']);

    $stmt = $db->prepare("DELETE FROM portal_tickets WHERE id = ?");
    $stmt->execute([$delId]);

    $stmt2 = $db->prepare("DELETE FROM portal_ticket_messages WHERE ticket_id = ?");
    $stmt2->execute([$delId]);

    Logger::write(
        "admin_action",
        "Ticket silindi (#{$delId})",
        $admin['id']
    );

    $success = "Ticket #{$delId} silindi.";
}


// Liste çekme
$where  = "";
$params = [];

if ($search !== "") {
    $where  = "WHERE t.subject LIKE ? OR u.username LIKE ? OR u.email LIKE ?";
    $params = ["%$search%", "%$search%", "%$search%"];
}

$query = $db->prepare("
    SELECT 
        t.id, t.subject, t.status, t.created_at, u.username, u.email
    FROM portal_tickets t
    LEFT JOIN portal_users u ON t.user_id = u.id
    $where
    ORDER BY t.id DESC
");
$query->execute($params);
$tickets = $query->fetchAll();

// Sayfa görüntülendi → log
Logger::write(
    "admin_action",
    "Ticket listesi görüntülendi",
    $admin['id']
);

?>
<!DOCTYPE html>
<html lang="tr">
<head>
<meta charset="UTF-8">
<title>Novapus Admin · Ticket Yönetimi</title>
<link rel="stylesheet" href="assets/admin.css">
</head>

<body class="admin-shell">

<?php include "includes/sidebar.php"; ?>

<div class="admin-main">

<header class="admin-topbar">
    <div class="at-title">
        <h1>Destek Talepleri</h1>
        <span>Kullanıcı ticket yönetimi</span>
    </div>

    <div class="at-user">
        <div class="at-user-info">
            <span class="at-user-label">Admin</span>
            <span class="at-user-name"><?= htmlspecialchars($admin['username']); ?></span>
        </div>
        <div class="at-user-avatar"><span>A</span></div>
    </div>
</header>

<main class="admin-content">

<?php if (!empty($success)): ?>
    <div class="admin-success-box"><?= $success ?></div>
<?php endif; ?>

<!-- ARAMA FORMU -->
<form method="get" class="admin-search-bar">
    <input type="text" name="s" placeholder="Konu, kullanıcı veya mail ara..." 
           value="<?= htmlspecialchars($search) ?>">
    <button class="admin-btn-search">Ara</button>
</form>

<!-- TICKET LİSTESİ -->
<div class="admin-panel-card">

<table class="apc-table">
    <thead>
        <tr>
            <th>ID</th>
            <th>Konu</th>
            <th>Kullanıcı</th>
            <th>Durum</th>
            <th>Tarih</th>
            <th>İşlem</th>
        </tr>
    </thead>
    <tbody>

    <?php if (empty($tickets)): ?>
        <tr><td colspan="6">Hiç ticket bulunamadı.</td></tr>
    <?php endif; ?>

    <?php foreach ($tickets as $t): ?>
        <tr>
            <td>#<?= $t['id'] ?></td>

            <td><?= htmlspecialchars($t['subject']) ?></td>

            <td>
                <?= htmlspecialchars($t['username'] ?: 'Bilinmiyor') ?><br>
                <span class="dim"><?= htmlspecialchars($t['email']) ?></span>
            </td>

            <td>
                <span class="ticket-status <?= $t['status'] ?>">
                    <?= strtoupper($t['status']) ?>
                </span>
            </td>

            <td><?= $t['created_at'] ?></td>

            <td>
                <a class="btn-admin-small blue" 
                   href="ticket_view.php?id=<?= $t['id'] ?>">
                   Görüntüle
                </a>

                <form action="" method="post" style="display:inline;"
                      onsubmit="return confirm('Ticket silinsin mi?');">
                    <input type="hidden" name="ticket_id" value="<?= $t['id'] ?>">
                    <button class="btn-admin-small red" name="delete_ticket">Sil</button>
                </form>
            </td>
        </tr>
    <?php endforeach; ?>

    </tbody>
</table>

</div>

</main>
</div>

</body>
</html>