<?php
// portal/pages/contact.php

$message = "";
$success = "";

// Form gönderildi mi?
if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    $email   = trim($_POST['email'] ?? '');
    $textMsg = trim($_POST['message'] ?? '');

    if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        $message = "Geçerli bir e-posta adresi girin.";
    } elseif (strlen($textMsg) < 5) {
        $message = "Mesaj çok kısa.";
    } else {

        // Dosya yükleme işlemi
        $uploadedFile = null;

        if (!empty($_FILES['attachment']['name'])) {
            $file = $_FILES['attachment'];
            $ext  = strtolower(pathinfo($file['name'], PATHINFO_EXTENSION));

            $allowed = ['png', 'jpg', 'jpeg'];

            if (!in_array($ext, $allowed)) {
                $message = "Yalnızca PNG, JPG ve JPEG dosyalarına izin verilir.";
            } elseif ($file['size'] > 4 * 1024 * 1024) {
                $message = "Dosya boyutu en fazla 4MB olabilir.";
            } else {
                $newName = "contact_" . time() . "_" . rand(1000,9999) . "." . $ext;
                $savePath = __DIR__ . "/../uploads/" . $newName;

                if (move_uploaded_file($file['tmp_name'], $savePath)) {
                    $uploadedFile = $newName;
                }
            }
        }

        if (!$message) {
            // ✔ KAYIT — Şimdilik sadece başarı mesajı
            // İstersen buraya e-posta gönderimi veya DB kaydı eklerim.

            $success = "Mesajın başarıyla gönderildi! En kısa sürede dönüş yapacağız.";

            // Eğer istersen:
            // $success .= "<br>Yüklenen dosya: " . htmlspecialchars($uploadedFile);
        }
    }
}
?>

<section class="section narrow">

    <h2>İletişim</h2>
    <p>Genel sorularını, hata bildirimlerini veya önerilerini buradan iletebilirsin.</p>

    <?php if (!empty($success)): ?>
        <div class="form-success" style="margin-bottom:12px;color:#22c55e;">
            <?= $success ?>
        </div>
    <?php endif; ?>

    <?php if (!empty($message)): ?>
        <div class="form-error" style="margin-bottom:12px;color:#f87171;">
            <?= $message ?>
        </div>
    <?php endif; ?>

    <form action="" method="post" class="form-card" enctype="multipart/form-data">

        <label class="form-label">
            E-posta adresin
            <input type="email" name="email" class="form-input" required>
        </label>

        <label class="form-label">
            Mesajın
            <textarea name="message" class="form-input" rows="5" required></textarea>
        </label>

        <label class="form-label">
            Ekran Görüntüsü (opsiyonel)
            <input type="file" name="attachment" class="form-input" accept=".png,.jpg,.jpeg">
        </label>

        <button type="submit" class="btn btn-primary w-100">Gönder</button>
    </form>
</section>