<?php
require_once __DIR__ . '/../includes/db.php';

$message = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $email = trim($_POST['email'] ?? '');

    if ($email) {
        $db = DB::get();
        $stmt = $db->prepare("SELECT id FROM portal_users WHERE email = ?");
        $stmt->execute([$email]);
        $user = $stmt->fetch();

        if ($user) {
            $token   = bin2hex(random_bytes(32));
            $expires = date('Y-m-d H:i:s', time() + 3600);

            $stmt = $db->prepare("
                UPDATE portal_users
                SET reset_token = ?, reset_expires = ?
                WHERE id = ?
            ");
            $stmt->execute([$token, $expires, $user['id']]);

            $link = "https://novapus.com/portal/index.php?page=reset_password&token=$token";

            $subject = "Novapus | Şifre Sıfırlama";
            $body = "
Merhaba,

Şifreni sıfırlamak için aşağıdaki bağlantıya tıkla:
$link

Bu bağlantı 1 saat geçerlidir.

Novapus
";

            @mail($email, $subject, $body, "From: Novapus <no-reply@novapus.com>");

            $message = "Şifre sıfırlama bağlantısı e-posta adresine gönderildi.";
        } else {
            $message = "Bu e-posta adresi bulunamadı.";
        }
    }
}
?>

<div class="login-box">
    <h3>Şifre Sıfırlama</h3>

    <?php if ($message): ?>
        <div class="alert"><?= htmlspecialchars($message) ?></div>
    <?php endif; ?>

    <form method="post">
        <input type="email" name="email" placeholder="E-posta adresin" required>
        <button type="submit">Sıfırlama Linki Gönder</button>
    </form>
</div>
