<?php
require_once __DIR__ . '/includes/db.php';

$db = DB::get();
$token = $_GET['token'] ?? '';

if (!$token) {
    die("<h2 style='text-align:center;margin-top:40px;font-family:Arial;color:#ff726f;'>
            Geçersiz doğrulama bağlantısı.
         </h2>");
}

// Token'a göre kullanıcıyı bul
$stmt = $db->prepare("SELECT * FROM portal_users WHERE email_verify_token = ?");
$stmt->execute([$token]);
$user = $stmt->fetch();

if (!$user) {
    die("<h2 style='text-align:center;margin-top:40px;font-family:Arial;color:#ff726f;'>
            Bu doğrulama bağlantısı geçersiz veya daha önce kullanılmış.
         </h2>");
}

// Email doğrula
$stmt = $db->prepare("
    UPDATE portal_users 
    SET email_verified = 1, email_verify_token = NULL
    WHERE id = ?
");
$stmt->execute([$user['id']]);

?>
<!DOCTYPE html>
<html lang="tr">
<head>
<meta charset="UTF-8">
<title>Novapus - Hesabın Doğrulandı</title>
<style>
    body {
        background: #0a0f1a;
        font-family: Arial, Helvetica, sans-serif;
        margin: 0;
        padding: 0;
        color: white;
    }

    .verify-box {
        max-width: 480px;
        margin: 60px auto;
        background: #111726;
        padding: 35px;
        border-radius: 14px;
        text-align: center;
        box-shadow: 0 0 25px rgba(0,0,0,0.4);
    }

    .verify-box img {
        width: 160px;
        filter: drop-shadow(0 0 10px #4db8ff);
        margin-bottom: 20px;
    }

    .verify-title {
        font-size: 24px;
        margin-bottom: 14px;
        letter-spacing: 0.4px;
    }

    .verify-text {
        font-size: 15px;
        line-height: 1.6;
        color: #c7c7c7;
        margin-bottom: 30px;
    }

    .btn {
        background: #3d7cff;
        padding: 12px 24px;
        font-size: 16px;
        color: white;
        text-decoration: none;
        border-radius: 8px;
        box-shadow: 0 0 15px rgba(61,124,255,0.6);
        display: inline-block;
    }

    .btn:hover {
        opacity: 0.85;
    }

</style>
</head>
<body>

<div class="verify-box">
    <img src="https://novapus.com/portal/assets/img/logo-3d.png" alt="Novapus Logo">

    <h2 class="verify-title">Hesabın Başarıyla Doğrulandı!</h2>

    <p class="verify-text">
        Tebrikler Komutan! Artık Novapus galaksisinde tüm özellikleri kullanmaya hazırsın.<br>
        Aşağıdaki butona tıklayarak giriş yapabilirsin.
    </p>

    <a href="index.php?page=login" class="btn">Giriş Yap</a>
</div>

</body>
</html>
