<?php
/**
 *  OPBE
 *  Copyright (C) 2013  Jstar
 *
 * This file is part of OPBE.
 * 
 * OPBE is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * OPBE is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with OPBE.  If not, see <http://www.gnu.org/licenses/>.
 *
 * @package OPBE
 * @author Jstar <frascafresca@gmail.com>
 * @copyright 2013 Jstar <frascafresca@gmail.com>
 * @license http://www.gnu.org/licenses/ GNU AGPLv3 License
 * @version beta(26-10-2013)
 * @link https://github.com/jstar88/opbe
 */
abstract class Events
{

    public static function event_moon($moonProb)
    {
        $SizeMin = MOON_MIN_START_SIZE + ($moonProb * MOON_MIN_FACTOR);
        $SizeMax = MOON_MAX_START_SIZE + ($moonProb * MOON_MAX_FACTOR);
        $size = rand($SizeMin, $SizeMax);
        $fields = floor(pow($size / 1000, 2));
        return array('size' => $size, 'fields' => $fields);
    }
}

?>