<?php

class ShowOfficersPage extends AbstractAdminPage
{
    private $BONUS_KEYS = array(

        // Kaynak üretimi (5)
        'mine_metal'         => 'Metal üretimi',
        'mine_crystal'       => 'Kristal üretimi',
        'mine_deuterium'     => 'Deuterium üretimi',
        'mine_all'           => 'Tüm kaynak üretimi',
        'mine_energy'        => 'Enerji üretimi',

        // Depo kapasitesi (4)
        'storage_metal'      => 'Metal depo kapasitesi',
        'storage_crystal'    => 'Kristal depo kapasitesi',
        'storage_deuterium'  => 'Deuterium depo kapasitesi',
        'storage_all'        => 'Genel depo kapasitesi',

        // İnşa / Araştırma / Üretim hızları (4)
        'build_time'         => 'Bina yapım süresi',
        'ship_time'          => 'Gemi üretim süresi',
        'defense_time'       => 'Savunma üretim süresi',
        'research_time'      => 'Araştırma süresi',

        // Filo (5)
        'ship_speed'         => 'Gemi hızı',
        'fleet_speed'        => 'Filo uçuş hızı',
        'fleet_fuel_use'     => 'Yakıt tüketimi',
        'fleet_attack'       => 'Filo saldırı bonusu',
        'fleet_defense'      => 'Filo savunma bonusu',

        // Expedition bonusları (7)
        'exp_event_chance'      => 'İyi event şansı',
        'exp_find_rate'         => 'Kaynak bulma oranı',
        'exp_dm_find_rate'      => 'DM bulma oranı',
        'exp_dm_multiplier'     => 'DM çarpan bonusu',
        'exp_ship_find_rate'    => 'Gemi bulma oranı',
        'exp_fleet_loss_reduce' => 'Kara delik kayıp azaltma',
        'exp_time_reduce'       => 'Dönüş süresi azaltma',

        // Karanlık madde bulma (1)
        'exp_more'           => 'Ekstra DM bulma bonusu',

        // Global bonuslar (2)
        'Resource'           => 'Genel üretim bonusu',
        'Energy'             => 'Genel enerji bonusu',

        // Ekstra (4)
        'ShipStorage'        => 'Gemi depolama kapasitesi',
        'FlyTime'            => 'Uçuş süresi',
        'FleetSlots'         => 'Filo slotu',
        'MoreFound'          => 'Ekstra keşif bonusu'
    );

    public function __construct()
    {
        parent::__construct();
        $this->allowedWithAuth    = true;
        $this->allowedUserLevels  = array(AUTH_ADM);
    }

    public function show()
    {
        $db = Database::get();

        $sql      = "SELECT * FROM uni1_officers ORDER BY id ASC;";
        $officers = $db->select($sql);

        foreach ($officers as &$o) {
            $o['bonuses'] = $db->select(
                "SELECT effect_key, effect_value
                 FROM uni1_officer_effects
                 WHERE officer_id = :id;",
                array(':id' => $o['id'])
            );
        }

        $this->assign(array(
            'officers' => $officers
        ));

        $this->display('page.officers.default.tpl');
    }

    public function add()
    {
        $this->assign(array(
            'BONUS_KEYS' => $this->BONUS_KEYS
        ));

        $this->display('page.officers.add.tpl');
    }

    public function saveAdd()
    {
        $db = Database::get();

        $name   = HTTP::_GP('name', '');
        $desc   = HTTP::_GP('description', '');
        $image  = HTTP::_GP('image', '');
        $dm     = HTTP::_GP('cost_dm', 0);
        $dur    = HTTP::_GP('duration_hours', 0);
        $active = HTTP::_GP('active', 1);

        $db->insert(
            "INSERT INTO uni1_officers SET
                name = :name,
                description = :desc,
                image = :image,
                cost_dm = :dm,
                duration_hours = :dur,
                active = :active;",
            array(
                ':name'   => $name,
                ':desc'   => $desc,
                ':image'  => $image,
                ':dm'     => $dm,
                ':dur'    => $dur,
                ':active' => $active
            )
        );

        $newID = $db->lastInsertId();

        $bonusValues = HTTP::_GP('bonus_value', array());

        foreach ($bonusValues as $key => $value) {
            if ($value === "" || $value == 0) {
                continue;
            }

            $db->insert(
                "INSERT INTO uni1_officer_effects SET
                    officer_id = :oid,
                    effect_key = :ek,
                    effect_value = :ev;",
                array(
                    ':oid' => $newID,
                    ':ek'  => $key,
                    ':ev'  => $value
                )
            );
        }

        $this->printMessage(
            "Yeni subay başarıyla eklendi.",
            true,
            array('?page=officers', 2)
        );
    }

    public function edit()
    {
        $id = HTTP::_GP('id', 0);
        $db = Database::get();

        $officer = $db->selectSingle(
            "SELECT * FROM uni1_officers WHERE id = :id;",
            array(':id' => $id)
        );

        if (empty($officer)) {
            $this->printMessage("Subay bulunamadı!", false, array('?page=officers', 2));
        }

        $effects_raw = $db->select(
            "SELECT effect_key, effect_value
             FROM uni1_officer_effects
             WHERE officer_id = :id;",
            array(':id' => $id)
        );

        $effects = array();
        foreach ($effects_raw as $e) {
            $effects[$e['effect_key']] = $e;
        }

        $this->assign(array(
            'officer'    => $officer,
            'effects'    => $effects,
            'BONUS_KEYS' => $this->BONUS_KEYS
        ));

        $this->display('page.officers.edit.tpl');
    }

    public function saveEdit()
    {
        $db = Database::get();

        $id     = HTTP::_GP('id', 0);
        $name   = HTTP::_GP('name', '');
        $desc   = HTTP::_GP('description', '');
        $image  = HTTP::_GP('image', '');
        $dm     = HTTP::_GP('cost_dm', 0);
        $dur    = HTTP::_GP('duration_hours', 0);
        $active = HTTP::_GP('active', 1);

        // Subay güncelle
        $db->update(
            "UPDATE uni1_officers SET
                name = :name,
                description = :description,
                image = :image,
                cost_dm = :dm,
                duration_hours = :dur,
                active = :active
             WHERE id = :id;",
            array(
                ':id'          => $id,
                ':name'        => $name,
                ':description' => $desc,
                ':image'       => $image,
                ':dm'          => $dm,
                ':dur'         => $dur,
                ':active'      => $active,
            )
        );

        /* ============================================
           BONUS GÜNCELLEME / SİLME
        ============================================ */

        $bonusValues = HTTP::_GP('bonus_value', []);   // bonus_value[key] = value
        $toDelete    = HTTP::_GP('bonus_delete', []);  // bonus_delete[key] = "on"

        foreach ($bonusValues as $key => $value)
        {
            // Silme işareti varsa → sil
            if (isset($toDelete[$key])) {
                $db->delete(
                    "DELETE FROM uni1_officer_effects WHERE officer_id = :oid AND effect_key = :ek;",
                    array(':oid' => $id, ':ek' => $key)
                );
                continue;
            }

            // Değer boşsa → hiçbir işlem yapma
            if ($value === "" || $value == 0) {
                continue;
            }

            // Var mı kontrol et
            $exists = $db->selectSingle(
                "SELECT COUNT(*) as c FROM uni1_officer_effects
                 WHERE officer_id = :oid AND effect_key = :ek;",
                array(':oid' => $id, ':ek' => $key),
                'c'
            );

            if ($exists) {
                // Güncelle
                $db->update(
                    "UPDATE uni1_officer_effects SET effect_value = :val
                     WHERE officer_id = :oid AND effect_key = :ek;",
                    array(':val' => $value, ':oid' => $id, ':ek' => $key)
                );
            } else {
                // Yoksa ekle
                $db->insert(
                    "INSERT INTO uni1_officer_effects SET
                        officer_id = :oid,
                        effect_key = :ek,
                        effect_value = :ev;",
                    array(
                        ':oid' => $id,
                        ':ek'  => $key,
                        ':ev'  => $value
                    )
                );
            }
        }

        /* ============================================
           YENİ BONUS EKLEME
        ============================================ */

        $newKeys   = HTTP::_GP('new_bonus_key', []);
        $newValues = HTTP::_GP('new_bonus_value', []);

        if (!empty($newKeys)) {
            foreach ($newKeys as $i => $k) {

                $k = trim($k);
                $v = isset($newValues[$i]) ? $newValues[$i] : "";

                if ($k == "" || $v == "" || $v == 0) {
                    continue;
                }

                $db->insert(
                    "INSERT INTO uni1_officer_effects SET
                        officer_id = :oid,
                        effect_key = :ek,
                        effect_value = :ev;",
                    array(
                        ':oid' => $id,
                        ':ek'  => $k,
                        ':ev'  => $v
                    )
                );
            }
        }

        /* ============================================
           TAMAM – GERİ DÖN
        ============================================ */

        $this->printMessage(
            "Subay ve bonuslar başarıyla güncellendi.",
            true,
            array('?page=officers', 2)
        );
    }

    public function delete()
    {
        $id = HTTP::_GP('id', 0);
        $db = Database::get();

        $db->delete(
            "DELETE FROM uni1_officer_effects WHERE officer_id = :id;",
            array(':id' => $id)
        );

        $db->delete(
            "DELETE FROM uni1_officers WHERE id = :id;",
            array(':id' => $id)
        );

        $this->printMessage(
            "Subay tamamen silindi.",
            true,
            array('?page=officers', 2)
        );
    }

    public function addEffect()
    {
        $id    = HTTP::_GP('id', 0);
        $key   = HTTP::_GP('effect_key', '');
        $value = HTTP::_GP('effect_value', 0);

        if (empty($key)) {
            $this->printMessage("Bonus anahtarı boş olamaz!", false, array("?page=officers&mode=edit&id={$id}", 2));
        }

        $db = Database::get();

        $db->insert(
            "INSERT INTO uni1_officer_effects SET
                officer_id = :oid,
                effect_key = :ek,
                effect_value = :ev;",
            array(
                ':oid' => $id,
                ':ek'  => $key,
                ':ev'  => $value
            )
        );

        $this->printMessage(
            "Bonus eklendi.",
            true,
            array("?page=officers&mode=edit&id={$id}", 2)
        );
    }

    public function delEffect()
    {
        $id  = HTTP::_GP('id', 0);
        $key = HTTP::_GP('key', '');

        $db = Database::get();

        $db->delete(
            "DELETE FROM uni1_officer_effects WHERE officer_id = :oid AND effect_key = :ek;",
            array(':oid' => $id, ':ek' => $key)
        );

        $this->printMessage(
            "Bonus silindi.",
            true,
            array("?page=officers&mode=edit&id={$id}", 2)
        );
    }
}
