<?php

class ShowMarketPage extends AbstractGamePage
{
    public static $requireModule = 0;

    function __construct()
    {
        parent::__construct();
    }

    public function show()
    {
        global $LNG;
        $db = Database::get();

        // TÜM AKTİF PAKETLERİ ÇEK (dokunma dedin — aynen bıraktım)
        $packages = $db->select("SELECT * FROM %%MARKET_PACKAGES%% WHERE active = 1 ORDER BY id ASC;");

        $dmPacks        = [];
        $resourcePacks  = [];
        $boosters       = [];

        foreach ($packages as $p) {

            if ($p['type'] === 'dm') {
                $dmPacks[] = [
                    'id'      => (int)$p['id'],
                    'title'   => $p['title'],
                    'desc'    => $p['description'],
                    'price'   => $p['price'],
                    'image'   => $p['image'],
                    'reward'  => $p['reward_value']
                ];
            }

            if ($p['type'] === 'resource') {
                $resourcePacks[] = [
                    'id'      => (int)$p['id'],
                    'title'   => $p['title'],
                    'desc'    => $p['description'],
                    'price'   => $p['price'],
                    'image'   => $p['image'],
                    'reward'  => $p['reward_value']
                ];
            }

            if ($p['type'] === 'boost') {
                $boosters[] = [
                    'id'      => (int)$p['id'],
                    'title'   => $p['title'],
                    'desc'    => $p['description'],
                    'price'   => $p['price'],
                    'image'   => $p['image'],
                    'reward'  => $p['reward_value']
                ];
            }
        }

        $this->assign([
            'dmPacks'        => $dmPacks,
            'resourcePacks'  => $resourcePacks,
            'boosters'       => $boosters,
        ]);

        $this->display('page.market.default.tpl');
    }

    // =====================================================
    //  BUY — SATIN ALMA FONKSİYONU (KESİN DOĞRU SÜRÜM)
    // =====================================================
    public function buy()
{
    $packageID = intval(HTTP::_GP('id', 0));
    $method    = HTTP::_GP('method', 'unknown');

    if ($packageID <= 0) {
        $this->printMessage(
            "Geçersiz paket ID!",
            true,
            ["game.php?page=market"]
        );
    }

    // Kullanıcıyı globalden al (KESİN ÇÖZÜM)
    $USER = $GLOBALS['USER'];

    $db = Database::get();

    // PAKETİ DOĞRULA
    $package = $db->selectSingle(
        "SELECT * FROM %%MARKET_PACKAGES%% WHERE id = :id AND active = 1",
        [':id' => $packageID]
    );

    if (empty($package)) {
        $this->printMessage(
            "Bu paket mevcut değil veya pasif.",
            true,
            ["game.php?page=market"]
        );
    }

    // SİPARİŞ OLUŞTUR
    $db->insert(
        "INSERT INTO %%MARKET_ORDERS%% SET
            userID    = :user,
            packageID = :pid,
            method    = :method,
            time      = :time,
            status    = 'pending'",
        [
            ':user'   => $USER['id'],   // 🔥 DÜZELTİLEN SATIR
            ':pid'    => $packageID,
            ':method' => $method,
            ':time'   => TIMESTAMP
        ]
    );

    $this->printMessage(
    "Shopier siparişiniz oluşturuldu! İşlem tamamlandıktan sonra ödül hesabınıza geçecektir.",
    true,
    "game.php?page=market"
);

}

}
