{block name="title" prepend}{$LNG.lm_alliance}{/block}
{block name="content"}

<!-- === HEADER === -->
<div class="page-header-wrapper mb-3">
    <img src="styles/theme/gow/img/headers/alliance_header.jpg" class="page-header-img">
</div>

<style>
/* HEADER */
.page-header-wrapper{
    width: 654px;
    height: 200px;
    margin: 0 auto 30px;
    border-radius: 10px;
    overflow: hidden;
    box-shadow:0 0 12px rgba(0,0,0,.45);
}
.page-header-img{
    width:100%;
    height:100%;
    object-fit:cover;
}

/* GLOBAL CARD */
.nova-card{
    width:100%;
    max-width: 1000px;
    margin:0 auto 25px;
    background:rgba(22,28,44,0.55);
    backdrop-filter:blur(8px);
    border:1px solid rgba(120,150,255,0.22);
    border-radius:14px;
    padding:22px 26px;
    box-shadow:0 0 12px rgba(0,0,0,.45);
}

.nova-title{
    font-size:20px;
    font-weight:bold;
    color:#9fc5ff;
    text-align:center;
    margin-bottom:20px;
}

/* BUTTONS */
.nova-btn{
    display:block;
    width:100%;
    text-align:center;
    padding:10px 0;
    border-radius:10px;
    font-weight:bold;
    color:#fff;
    margin:6px 0;
    background:linear-gradient(90deg,#3a7bff,#5ea0ff);
    border:1px solid rgba(120,150,255,0.22);
    transition:.2s;
}
.nova-btn:hover{
    box-shadow:0 0 10px rgba(120,150,255,0.7);
}

/* TEXTAREA card */
textarea{
    background:rgba(10,10,20,0.65)!important;
    color:#e8ecff!important;
    border:1px solid rgba(120,150,255,0.25)!important;
    border-radius:10px!important;
    padding:10px!important;
}

/* INPUTS */
.nova-input{
    width:100%;
    background:rgba(10,10,20,0.65);
    border:1px solid rgba(120,150,255,0.25);
    border-radius:10px;
    padding:6px 10px;
    color:#e8ecff;
}
.nova-input:focus{
    outline:none;
    border-color:#5ea0ff;
}

.nova-table td, .nova-table th{
    padding:8px 5px;
    color:#d8e4ff;
    text-align:left;
}

.nova-subtitle{
    font-weight:bold;
    color:#b8d6ff;
    font-size:16px;
    margin-bottom:10px;
    text-align:center;
}

/* Reset & Save buttons */
.nova-reset, .nova-save{
    padding:10px 14px;
    border-radius:10px;
    margin-right:10px;
    cursor:pointer;
    border:none;
    font-weight:bold;
}
.nova-reset{
    background:#444;
    color:#fff;
}
.nova-save{
    background:#3a7bff;
    color:white;
}
.nova-save:hover{
    background:#5fa6ff;
}

/* Danger buttons */
.nova-danger{
    background:#b63838;
    padding:10px;
    border-radius:10px;
    text-align:center;
    font-weight:bold;
    color:white;
    border:none;
}
.nova-danger:hover{
    background:#d94a4a;
}

.nova-primary{
    background:#3274ff;
    padding:10px;
    border-radius:10px;
    text-align:center;
    color:white;
    border:none;
}
.nova-primary:hover{
    background:#4e8eff;
}

</style>


<!-- === YÖNETİM BUTONLARI === -->
<div class="nova-card">
    <div class="nova-title">{$LNG.al_manage_alliance}</div>

    <a class="nova-btn" href="game.php?page=alliance&amp;mode=admin&amp;action=permissions">{$LNG.al_manage_ranks}</a>
    <a class="nova-btn" href="game.php?page=alliance&amp;mode=admin&amp;action=members">{$LNG.al_manage_members}</a>

    {if $rights.DIPLOMATIC}
    <a class="nova-btn" href="game.php?page=alliance&amp;mode=admin&amp;action=diplomacy">{$LNG.al_manage_diplo}</a>
    {/if}
</div>


<form action="game.php?page=alliance&mode=admin" method="post">
<input type="hidden" name="textMode" value="{$textMode}">
<input type="hidden" name="send" value="1">


<!-- === İTTİFAK METİNLERİ === -->
<div class="nova-card">
    <div class="nova-title">{$LNG.al_texts}</div>

    <div class="d-flex gap-2 mb-3">
        <a class="nova-btn" href="game.php?page=alliance&amp;mode=admin&amp;textMode=external">{$LNG.al_outside_text}</a>
        <a class="nova-btn" href="game.php?page=alliance&amp;mode=admin&amp;textMode=internal">{$LNG.al_inside_text}</a>
        <a class="nova-btn" href="game.php?page=alliance&amp;mode=admin&amp;textMode=apply">{$LNG.al_request_text}</a>
    </div>

    <textarea name="text" id="text" rows="15">{$text}</textarea>

    <div class="mt-3">
        <input class="nova-reset" type="reset" value="{$LNG.al_circular_reset}">
        <input class="nova-save" type="submit" value="{$LNG.al_save}">
    </div>
</div>


<!-- === İTTİFAK AYARLARI === -->
<div class="nova-card">
    <div class="nova-title">{$LNG.al_manage_options}</div>

    <table class="nova-table">

        <tr>
            <td>{$LNG.al_tag}</td>
            <td><input class="nova-input" type="text" name="ally_tag" value="{$ally_tag}" maxlength="8" required></td>
        </tr>

        <tr>
            <td>{$LNG.al_name}</td>
            <td><input class="nova-input" type="text" name="ally_name" value="{$ally_name}" maxlength="30" required></td>
        </tr>

        <tr>
            <td>{$LNG.al_manage_founder_rank}</td>
            <td><input class="nova-input" type="text" name="owner_range" value="{$ally_owner_range}"></td>
        </tr>

        <tr>
            <td>{$LNG.al_web_site}</td>
            <td><input class="nova-input" type="text" name="web" value="{$ally_web}"></td>
        </tr>

        <tr>
            <td>{$LNG.al_manage_image}</td>
            <td><input class="nova-input" type="text" name="image" value="{$ally_image}"></td>
        </tr>

        <tr>
            <td>{$LNG.al_view_stats}</td>
            <td>{html_options name=stats options=$YesNoSelector selected=$ally_stats_data}</td>
        </tr>

        <tr>
            <td>{$LNG.al_view_diplo}</td>
            <td>{html_options name=diplo options=$YesNoSelector selected=$ally_diplo_data}</td>
        </tr>

        <tr>
            <td>{$LNG.al_view_events}</td>
            <td>
                <select name="events[]" size="{$available_events|@count}" multiple class="nova-input" style="height:auto;">
                    {foreach $available_events as $id => $mission}
                        {assign var=isSelected value=''}
                        {foreach $ally_events as $selected_events}
                            {if $selected_events == $id}{assign var=isSelected value='selected'}{/if}
                        {/foreach}
                        <option value="{$id}" {$isSelected}>{$mission}</option>
                    {/foreach}
                </select>
            </td>
        </tr>

        <tr>
            <td>{$LNG.al_manage_requests}</td>
            <td>{html_options name=request_notallow options=$RequestSelector selected=$ally_request_notallow}</td>
        </tr>

        <tr>
            <td>{$LNG.al_set_max_members}</td>
            <td>{$ally_members} / <input class="nova-input" type="number" min="1" name="ally_max_members" value="{$ally_max_members}"></td>
        </tr>

        <tr>
            <td>{$LNG.al_manage_request_min_points}</td>
            <td><input class="nova-input" type="number" min="0" name="request_min_points" value="{$ally_request_min_points}"></td>
        </tr>

        <tr>
            <td colspan="2">
                <input class="nova-reset" type="reset" value="{$LNG.al_circular_reset}">
                <input class="nova-save" type="submit" value="{$LNG.al_save}">
            </td>
        </tr>

    </table>
</div>


<!-- === İTTİFAK KAPATMA / DEVRETME === -->
{if $AllianceOwner}

<div class="nova-card">
    <div class="nova-title">{$LNG.al_disolve_alliance}</div>
    <form action="game.php?page=alliance&amp;mode=admin&amp;action=close" method="post">
        <button class="nova-danger w-100" onclick="return confirm('{$LNG.al_close_ally}');">
            {$LNG.al_continue}
        </button>
    </form>
</div>

<div class="nova-card">
    <div class="nova-title">{$LNG.al_transfer_alliance}</div>
    <form action="game.php?page=alliance&amp;mode=admin&amp;action=transfer" method="post">
        <button class="nova-primary w-100">{$LNG.al_continue}</button>
    </form>
</div>

{/if}

</form>

{/block}


{block name="script" append}
<script type="text/javascript" src="scripts/base/tinymce/tiny_mce_gzip.js"></script>
<script>
$(function() {
    tinyMCE_GZ.init({
        plugins : 'bbcode,fullscreen',
        themes : 'advanced',
        languages : '{$lang}',
    }, function() {
        tinyMCE.init({
            language : '{$lang}',
            script_url : 'scripts/base/tinymce/tiny_mce.js',
            theme : "advanced",
            mode : "textareas",
            plugins : "bbcode,fullscreen",
            theme_advanced_buttons1 : "bold,italic,underline,undo,redo,link,unlink,image,forecolor,styleselect,removeformat,cleanup,code,fullscreen",
            theme_advanced_toolbar_location : "bottom",
            theme_advanced_toolbar_align : "center",
            content_css : "{$dpath}formate.css",
        });
    });
});
</script>
{/block}
