{block name="title" prepend}{$LNG.lm_fleettrader}{/block}
{block name="content"}

<style>
/* === CORPORATE MILITARY THEME === */

.nova-wrapper{
    max-width:1180px;
    margin:0 auto;
    display:flex;
    gap:22px;
    padding:6px 0;
}

/* === SOL PANEL === */
.nova-left{
    flex:1;
    background:linear-gradient(180deg,#0d1118 0%,#0b1016 100%);
    padding:18px;
    border-radius:10px;
    border:1px solid rgba(80,120,150,0.4);
    box-shadow:0 0 22px rgba(0,0,0,0.6), inset 0 0 25px rgba(10,20,35,0.45);
    position:relative;
    overflow:hidden;
}

.nova-left::before{
    content:"";
    position:absolute;
    inset:0;
    background:repeating-linear-gradient(
        to bottom,
        rgba(255,255,255,0.02) 0,
        rgba(255,255,255,0.02) 1px,
        transparent 3px
    );
    opacity:.2;
    pointer-events:none;
}

.nova-grid{
    position:relative;
    z-index:1;
    display:grid;
    grid-template-columns:repeat(3,1fr);
    gap:14px;
}

.nova-box{
    position:relative;
    background:#111820;
    padding:14px;
    border-radius:8px;
    border:1px solid rgba(90,140,160,0.35);
    box-shadow:inset 0 0 12px rgba(0,0,0,0.8), 0 0 12px rgba(0,0,0,0.4);
    transition:0.15s;
    cursor:pointer;
    overflow:hidden;
}

.nova-box:hover{
    border-color:rgba(120,180,200,0.8);
    transform:translateY(-3px);
}

.nova-box.active{
    border-color:#5fd0ff;
    box-shadow:
        0 0 22px rgba(95,208,255,0.55),
        inset 0 0 20px rgba(95,208,255,0.25);
}

.nova-active-badge{
    display:none;
    position:absolute;
    top:6px;right:6px;
    font-size:10px;
    padding:2px 6px;
    border-radius:6px;
    background:rgba(95,208,255,0.2);
    border:1px solid rgba(95,208,255,0.7);
}
.nova-box.active .nova-active-badge{
    display:inline-block;
}

.nova-box img{
    width:72px;
    height:72px;
    object-fit:contain;
    margin-bottom:6px;
    filter:drop-shadow(0 0 5px rgba(0,200,255,0.35));
}

.nova-stock{
    font-size:11px;
    opacity:.7;
}

/* === SAĞ PANEL === */
.nova-right{
    width:310px;
}

.nova-premium{
    background:#0c1218;
    border-radius:10px;
    border:1px solid rgba(110,150,180,0.45);
    padding:18px;
    box-shadow:inset 0 0 25px rgba(0,0,0,0.8), 0 0 25px rgba(0,0,0,0.6);
    position:relative;
}

.nova-premium-title{
    text-align:center;
    font-size:15px;
    font-weight:600;
    color:#cdeaff;
    margin-bottom:12px;
    text-transform:uppercase;
}

.nova-premium-divider{
    height:1px;
    margin:6px 4px 14px;
    background:linear-gradient(to right,transparent,rgba(120,180,220,0.6),transparent);
}

.nova-premium-charge{
    text-align:center;
    color:#89b4d6;
    margin-bottom:8px;
    font-size:13px;
}

.nova-premium-row{
    display:flex;
    justify-content:space-between;
    align-items:center;
    padding:4px 0;
    color:#d8ecff;
}

.nova-premium-amount{
    display:flex;
    justify-content:center;
    gap:6px;
    margin-bottom:12px;
}

.nova-premium-amount input{
    width:80px;
    text-align:center;
    background:#101820;
    border:1px solid rgba(140,180,210,0.35);
    color:#cdeaff;
}

.nova-premium-glow{
    width:100%;
    margin:10px 0;
    padding:8px 12px;
    text-align:center;
    font-size:14px;
    color:#b8e8ff;
    background:rgba(40,60,80,0.35);
    border:1px solid rgba(95,208,255,0.5);
    border-radius:8px;
    box-shadow:0 0 12px rgba(95,208,255,0.4),
                inset 0 0 8px rgba(95,208,255,0.25);
}

.nova-premium-btn{
    width:100%;
    margin-top:14px;
    background:#1a2733;
    border:1px solid rgba(120,180,220,0.6);
    color:#d8ecff;
}

/* === ÜST BİLGİ PANELİ — HURDACI === */

.nova-info-panel{
    width:100%;                  /* 🔥 .nova-right genişliğine tam oturur */
    max-width:310px;             /* 🔥 Taşmayı %100 engeller */
    background:#0c1218;
    border-radius:10px;
    border:1px solid rgba(110,150,180,0.45);
    padding:12px;
    margin-bottom:18px;
    box-shadow:
        inset 0 0 25px rgba(0,0,0,0.8),
        0 0 25px rgba(0,0,0,0.6);
    text-align:center;
}

.nova-info-panel .info-img{
    width:180px;
    height:180px;
    object-fit:contain;
    display:block;
    margin:0 auto 10px;
}

.nova-info-panel .info-text{
    font-size:13px;
    color:#bcd9f6;
    line-height:1.45;
    text-align:center;
    padding:0 4px;
}



</style>


<form action="game.php?page=fleetDealer" method="post">
<input type="hidden" name="mode" value="send">
<input type="hidden" name="shipID" id="shipID" value="0">
<input type="hidden" name="premium_rate" id="premium_rate_hidden" value="{$Charge}">

<div class="nova-wrapper">

    <!-- SOL PANEL -->
    <div class="nova-left">
        <div class="nova-grid">
        {foreach $shipIDs as $shipID}
            <div class="nova-box" id="card_{$shipID}" onclick="selectShip({$shipID});">
                <span class="nova-active-badge">SEÇİLİ</span>
                <img src="{$dpath}gebaeude/{$shipID}.gif">
                <div class="fw-bold mb-1">{$LNG.tech.$shipID}</div>
                <div class="nova-stock" id="stock_{$shipID}"></div>
            </div>
        {/foreach}
        </div>
    </div>
    
<!-- SAĞ -->
<div class="nova-right">

    <!-- ÜST BİLGİ PANELİ -->
    <div class="nova-info-panel">
        <img src="styles/theme/gow/img/headers/hurdaci_header.png" class="info-img">
        <div class="info-text">
            Hurdacı, elindeki gemileri kaynaklara dönüştürmeni sağlar.<br><br>
            <b>Premium oran</b> yükseldikçe daha çok kaynak kazanırsın.<br>
            Ancak bu işlem için belirli miktarda <b>Karanlık Madde</b> gerekir.<br><br>
            Soldan gemiyi seç, Sağdan Premium Oranı'nı seç ve dönüştürmek istediğin gemi miktarını yaz ve işlemi onayla.
        </div>
    </div>

    <!-- ALT SAĞ PANEL (HURDACI ÖZETİ) -->
    <div class="nova-premium">
        
        <div class="nova-premium-title">HURDACI ÖZETİ</div>
        <div class="nova-premium-divider"></div>

        <div class="nova-premium-charge">
            Temel oran: <b>{$Charge}%</b>
        </div>

        <div class="nova-premium-glow">
            DM Maliyeti: <span id="t_dmcost">0</span>
        </div>

        {assign var="rates" value=$ActivePremiumRates|default:array($Charge)}

        <div class="nova-premium-row">
            <span>Premium oran</span>
            <select id="premium_rate" onchange="updateRate();"
                    style="background:#101820;border:1px solid rgba(140,180,210,0.35);color:#cdeaff;padding:3px 6px;border-radius:6px;">
                <!-- İlk değer: her zaman temel oran -->
<option value="{$Charge}" selected>{$Charge}%</option>

<!-- Admin panelden aktif edilen oranlar -->
{foreach $rates as $rate}
    {if $rate != $Charge}
        <option value="{$rate}">{$rate}%</option>
    {/if}
{/foreach}

            </select>
        </div>

        <div class="nova-premium-row">
            <span>Seçili gemi</span><span id="sel_shipname">-</span>
        </div>

        <div class="nova-premium-amount">
            <input type="text" id="count" name="count" placeholder="0" onkeyup="updateFromInput();">
            <button class="btn btn-sm btn-secondary" onclick="setMax();return false;">Max</button>
        </div>

        <div class="nova-premium-row"><span>Metal</span><span id="t_metal">0</span></div>
        <div class="nova-premium-row"><span>Kristal</span><span id="t_crystal">0</span></div>
        <div class="nova-premium-row"><span>Deuterium</span><span id="t_deut">0</span></div>
        <div class="nova-premium-row"><span>Karanlık Madde</span><span id="t_dm">0</span></div>

        <button class="btn btn-primary nova-premium-btn">İşlemi Onayla</button>

    </div>

</div>


</div>
</form>

{block name="script" append}
<script>

var CostInfo   = {$CostInfos|json};
var Charge     = {$Charge};
var BaseDM     = {$BaseDM|default:2500};
var activeShip = 0;
var SelectedRate = Charge;


/* Yardımcı */
function getAmount(id){
    return CostInfo[id] ? parseInt(CostInfo[id][0]) || 0 : 0;
}
function getCost(id, res){
    return (CostInfo[id] && CostInfo[id][2][res]) ? parseInt(CostInfo[id][2][res]) : 0;
}


/* Premium oran değişti */
function updateRate(){
    var v = parseInt($("#premium_rate").val());
    if(isNaN(v) || v < 1) v = Charge;

    SelectedRate = v;
    $("#premium_rate_hidden").val(v);

    var c = parseInt($("#count").val());
    if(isNaN(c) || c < 1) c = 0;

    updateTotals(c);
}


/* İlk yükleme */
$(function(){
    var firstId = null;

    {foreach $shipIDs as $shipID}
        $("#stock_{$shipID}").text("Stok: " + getAmount({$shipID}));
        if(firstId === null) firstId = {$shipID};
    {/foreach}

    if(firstId !== null) selectShip(firstId);
});


/* Gemi seçme */
function clearActive(){
    {foreach $shipIDs as $shipID}
        $("#card_{$shipID}").removeClass("active");
    {/foreach}
}

function selectShip(id){
    activeShip = id;
    $("#shipID").val(id);
    clearActive();
    $("#card_"+id).addClass("active");
    $("#sel_shipname").text(CostInfo[id] ? CostInfo[id][1] : "-");
    $("#count").val("");
    updateTotals(0);
}


/* Miktar değiştikçe */
function updateFromInput(){
    if(!activeShip) return;

    var c = parseInt($("#count").val());
    if(isNaN(c) || c < 1) c = 0;

    var max = getAmount(activeShip);
    if(c > max){
        c = max;
        $("#count").val(max);
    }

    updateTotals(c);
}


/* MAX */
function setMax(){
    if(!activeShip) return;
    var max = getAmount(activeShip);
    $("#count").val(max);
    updateTotals(max);
}


/* ======== HESAPLAMA ======== */
function updateTotals(count){

    if(!activeShip || !CostInfo[activeShip]){
        $("#t_metal").text(0);
        $("#t_crystal").text(0);
        $("#t_deut").text(0);
        $("#t_dm").text(0);
        $("#t_dmcost").text(0);
        return;
    }

    /* Kaynak hesaplama */
    var factor = SelectedRate / 100;

    var m  = Math.floor(getCost(activeShip,901) * count * factor);
    var c  = Math.floor(getCost(activeShip,902) * count * factor);
    var d  = Math.floor(getCost(activeShip,903) * count * factor);
    var dm = Math.floor(getCost(activeShip,921) * count * factor);

    $("#t_metal").text(m);
    $("#t_crystal").text(c);
    $("#t_deut").text(d);
    $("#t_dm").text(dm);


    /* === DM MALİYETİ === */
/* %30 => BaseDM (2500)
   %40 => BaseDM * (40 / 30)
   %60 => BaseDM * (60 / 30) */

var dmSingle = Math.ceil((SelectedRate / Charge) * BaseDM);
var dmCost   = dmSingle * count;

if(!isFinite(dmCost) || isNaN(dmCost)) dmCost = 0;

$("#t_dmcost").text(dmCost);


}

</script>
{/block}

{/block}
