{block name="title" prepend}{$LNG.lm_trader}{/block}
{block name="content"}

<!-- HEADER -->
<div class="page-header-wrapper mb-3">
    <img src="styles/theme/gow/img/headers/trader_header.jpg" class="page-header-img" alt="">
</div>

<style>
/* ====== NOVAPUS TRADER – MODERN TASARIM ====== */

/* ===== HEADER TASARIM ===== */
.page-header-wrapper{
    width: 654px;
    height: 200px;
    margin: 0 auto 25px;
    border-radius: 6px;
    overflow: hidden;
    box-shadow: 0 0 12px rgba(0,0,0,.45);
}
.page-header-img{
    width: 100%;
    height: 100%;
    object-fit: cover;
}
/* Ana grid */
.nova-trader-wrapper{
    width: 100%;
    max-width: 760px;
    margin: 0 auto;
    display: grid;
    grid-template-columns: 1fr;
    gap: 20px;
}

/* Kart temeli */
.nova-card{
    background: rgba(22,28,44,0.55);
    backdrop-filter: blur(8px);
    border: 1px solid rgba(120,150,255,0.25);
    border-radius: 14px;
    padding: 18px 22px;
    position: relative;
    box-shadow: 0 0 12px rgba(0,0,0,0.45);
}

/* Kart başlığı */
.nova-card-title{
    font-size: 16px;
    font-weight: bold;
    color: #9fc5ff;
    margin-bottom: 14px;
}

/* Sağ üst X butonu */
.nova-close-btn{
    position: absolute;
    right: 12px;
    top: 10px;
    width: 18px;
    height: 18px;
    border-radius: 50%;
    background: rgba(255,255,255,0.08);
    color: #fff;
    font-size: 12px;
    line-height: 18px;
    text-align: center;
    cursor: pointer;
    transition: .2s;
}
.nova-close-btn:hover{
    background: rgba(255,80,80,0.55);
}

/* Kaynak ikon kutuları */
.nova-resource-select{
    display: flex;
    justify-content: center;
    gap: 25px;
    margin-top: 10px;
}

.nova-resource-item{
    width: 88px;
    height: 88px;
    border-radius: 14px;
    background: rgba(40,50,70,0.65);
    backdrop-filter: blur(8px);
    border: 1px solid rgba(150,180,255,0.25);
    box-shadow: 0 0 8px rgba(120,150,255,0.35);
    display: flex;
    flex-direction: column;
    justify-content: center;
    align-items: center;
    cursor: pointer;
    transition: .2s;
    text-align: center;
}
.nova-resource-item:hover{
    transform: translateY(-4px);
    box-shadow: 0 0 12px rgba(150,180,255,0.7);
}

/* Alt fiyat kutusu */
.nova-rate-box{
    text-align: center;
    font-size: 13px;
    color: #cfdcff;
    padding-top: 10px;
}


/* Uyarı kutusu (DM yoksa) */
.nova-warning{
    text-align:center;
    padding: 12px;
    background: rgba(255,0,0,0.15);
    border-radius: 12px;
    border:1px solid rgba(255,120,120,0.4);
    color:#ffdddd;
    margin-bottom:15px;
}

</style>


<div class="nova-trader-wrapper">

    <!-- KART 1: Tüccar Çağır / Uyarı -->
    <div class="nova-card">
        <div class="nova-close-btn">×</div>
        <div class="nova-card-title">{$LNG.tr_call_trader}</div>

        {if $requiredDarkMatter}
            <div class="nova-warning">
                {$requiredDarkMatter}
            </div>
        {/if}

        <div class="text-center color-blue fw-bold fs-12 mb-2">
            {$LNG.tr_call_trader_who_buys}
        </div>

        <div class="nova-resource-select">
            {foreach $charge as $resourceID => $chageData}
                {if !$requiredDarkMatter}
                <form action="game.php?page=trader" method="post">
                    <input type="hidden" name="mode" value="trade">
                    <input type="hidden" name="resource" value="{$resourceID}">

                    <button class="nova-resource-item" type="submit">
                        <img src="{$dpath}images/{$resource.$resourceID}.gif" width="42" height="32">
                        <span class="color-blue fs-10 mt-1">{$LNG.tech.$resourceID}</span>
                    </button>
                </form>

                {else}
                    <div class="nova-resource-item" style="cursor:default;opacity:.5;">
                        <img src="{$dpath}images/{$resource.$resourceID}.gif" width="42" height="32">
                        <span class="color-blue fs-10 mt-1">{$LNG.tech.$resourceID}</span>
                    </div>
                {/if}
            {/foreach}
        </div>

        <div class="nova-rate-box">
            <div>{$tr_cost_dm_trader}</div>
            <div>
                {$LNG.tr_exchange_quota}: 
                {$charge.901.903}/{$charge.902.903}/{$charge.903.903}
            </div>
        </div>
    </div>

</div>

{/block}
