<?php
session_start();
require_once __DIR__ . '/../includes/db.php';
require_once __DIR__ . '/../includes/Logger.php';

$db = DB::get();

$message = '';

/* ==============================
   GİRİŞ İŞLEMİ
============================== */

if (isset($_POST['login'])) {

    $username = trim($_POST['username']);
    $password = trim($_POST['password']);
    $ip       = $_SERVER['REMOTE_ADDR'];

    if ($username === '' || $password === '') {
        $message = "Kullanıcı adı ve şifre boş olamaz.";
    } else {

        $stmt = $db->prepare("SELECT * FROM portal_admins WHERE username = ?");
        $stmt->execute([$username]);
        $admin = $stmt->fetch();

        if (!$admin) {

            Logger::write(
                "security_fail",
                "Admin giriş denemesi (Kullanıcı bulunamadı): {$username} | IP: {$ip}",
                0
            );

            $message = "Kullanıcı adı veya şifre yanlış.";

        } elseif (!password_verify($password, $admin['password_hash'])) {

            Logger::write(
                "security_fail",
                "Admin giriş denemesi (Hatalı şifre): {$username} | IP: {$ip}",
                $admin['id']
            );

            $message = "Kullanıcı adı veya şifre yanlış.";

        } else {

            $_SESSION['admin_user'] = $admin;

            Logger::write(
                "admin_action",
                "Admin giriş yaptı: {$admin['username']} | IP: {$ip}",
                $admin['id']
            );

            header("Location: index.php");
            exit;
        }
    }
}
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <title>Novapus Admin · Giriş</title>
    <link rel="stylesheet" href="assets/admin.css?v=1005">
</head>

<body class="admin-login-body">

<!-- Dönen gezegen -->
<div class="admin-planet-glow"></div>

<!-- Yıldız katmanı -->
<div class="admin-star"></div>

<!-- Giriş kutusu -->
<div class="admin-login-container">

    <div class="admin-logo">N O V A P U S <br><span>Admin Paneli</span></div>

    <?php if (!empty($message)): ?>
        <div class="admin-error"><?= htmlspecialchars($message) ?></div>
    <?php endif; ?>

    <form action="" method="post" class="admin-login-form">

        <label>
            <span>Kullanıcı Adı</span>
            <input type="text" name="username" required>
        </label>

        <label>
            <span>Şifre</span>
            <input type="password" name="password" required>
        </label>

        <button type="submit" name="login" class="admin-btn-login">
            Giriş Yap
        </button>

    </form>

</div>

</body>
</html>
