<?php
session_start();
require_once __DIR__ . '/../includes/db.php';
require_once __DIR__ . '/../includes/Logger.php';

if (empty($_SESSION['admin_user'])) {
    header("Location: login.php");
    exit;
}

$db = DB::get();
$admin = $_SESSION['admin_user'];

$userId = isset($_GET['id']) ? (int)$_GET['id'] : 0;

if ($userId <= 0) {
    die("Geçersiz kullanıcı ID.");
}

/* ==============================
   PORTAL KULLANICISINI GETİR
================================ */

$stmt = $db->prepare("SELECT * FROM portal_users WHERE id = ?");
$stmt->execute([$userId]);
$user = $stmt->fetch();

if (!$user) {
    die("Kullanıcı bulunamadı.");
}

$message = '';
$success = '';

/* ==============================
   PROFİL GÜNCELLEME
================================ */

if (isset($_POST['update_user'])) {

    $username = trim($_POST['username']);
    $email    = trim($_POST['email']);

    if (strlen($username) < 3) {
        $message = "Kullanıcı adı en az 3 karakter olmalı.";
    }

    if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        $message = "Geçerli bir e-posta girin.";
    }

    if (!$message) {

        $check = $db->prepare("SELECT id FROM portal_users WHERE email = ? AND id != ?");
        $check->execute([$email, $userId]);

        if ($check->rowCount() > 0) {
            $message = "Bu e-posta başka bir kullanıcıda kayıtlı.";
        } else {
            $q = $db->prepare("UPDATE portal_users SET username = ?, email = ? WHERE id = ?");
            $q->execute([$username, $email, $userId]);

            Logger::write("admin_action", "Kullanıcı güncellendi (#{$userId} - {$username})", $admin['id']);
            $success = "Kullanıcı güncellendi!";
        }
    }
}

/* ==============================
   ŞİFRE SIFIRLAMA
================================ */

if (isset($_POST['reset_password'])) {

    $newPass = password_hash("123456", PASSWORD_DEFAULT);

    $q = $db->prepare("UPDATE portal_users SET password_hash = ? WHERE id = ?");
    $q->execute([$newPass, $userId]);

    Logger::write("admin_action", "Şifre sıfırlandı (#{$userId})", $admin['id']);

    $success = "Şifre 123456 olarak sıfırlandı.";
}

/* ==============================
   KULLANICI SİLME
================================ */

if (isset($_POST['delete_user'])) {

    $db->prepare("DELETE FROM portal_user_universe_accounts WHERE portal_user_id = ?")
        ->execute([$userId]);

    $db->prepare("DELETE FROM portal_users WHERE id = ?")
        ->execute([$userId]);

    Logger::write("admin_action", "Kullanıcı silindi (#{$userId})", $admin['id']);

    header("Location: users.php?deleted=1");
    exit;
}
/* ==============================
   TÜM EVRENLERİ LİSTELE (portal_universes)
================================ */

$allUniverses = $db->query("SELECT * FROM portal_universes ORDER BY id ASC")->fetchAll(PDO::FETCH_ASSOC);

/* Kullanıcının kayıtlı olduğu evrenler (varsa) */
$userUniverseMap = [];
foreach ($userUniverses as $uv) {
    $userUniverseMap[$uv['universe_id']] = $uv;
}

/* ==============================
   EVREN BİLGİSİ AL (Oto Evren Algılama)
================================ */

$universeQuery = $db->prepare("
    SELECT a.*, u.name, u.db_name 
    FROM portal_user_universe_accounts a
    INNER JOIN portal_universes u ON u.id = a.universe_id
    WHERE a.portal_user_id = ?
");
$universeQuery->execute([$userId]);
$userUniverses = $universeQuery->fetchAll();

$userUniverseMap = [];
foreach ($userUniverses as $uv) {
    $userUniverseMap[(int)$uv['universe_id']] = $uv;
}


/* Her evren için oyun tablosundan veriler alınacak */
$gameAccounts = [];



foreach ($userUniverses as $uv) {

    $uniId   = (int)$uv['universe_id'];
    $gameId  = (int)$uv['game_user_id'];
    $dbName  = $uv['db_name'];

    try {
        $stmt2 = $db->prepare("
            SELECT id, username, email, points, rank, onlinetime
            FROM {$dbName}.uni{$uniId}_users
            WHERE id = ?
        ");
        $stmt2->execute([$gameId]);
        $g = $stmt2->fetch();

        if ($g) {
            $gameAccounts[] = [
                'universe_name' => $uv['name'],
                'user_id'       => $g['id'],
                'username'      => $g['username'],
                'email'         => $g['email'],
                'points'        => $g['points'],
                'rank'          => $g['rank'],
                'onlinetime'    => $g['onlinetime']
            ];
        }
    } catch (Exception $e) {
        // oyun verisi çekilemezse boş geç
    }
}

?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <title>Novapus Admin · Kullanıcı Düzenle</title>
    <link rel="stylesheet" href="assets/admin.css">
</head>

<body class="admin-shell">

<?php include __DIR__ . '/includes/sidebar.php'; ?>

<div class="admin-main">
<header class="admin-topbar">
    <h1>Kullanıcı Düzenle</h1>
    <span>ID #<?= $userId ?></span>
</header>

<main class="admin-content">

<?php if ($success): ?>
    <div class="admin-success-box"><?= $success ?></div>
<?php endif; ?>

<?php if ($message): ?>
    <div class="admin-error-box"><?= $message ?></div>
<?php endif; ?>

<!-- AVATAR -->
<div class="admin-panel-card">
    <h2>Avatar</h2>

    <form action="" method="post" enctype="multipart/form-data">
        <label>Yeni Avatar
            <input type="file" name="avatar">
        </label>
        <button type="submit" name="update_avatar" class="admin-btn-save">Avatarı Güncelle</button>
    </form>
</div>

<!-- KULLANICI BİLGİLERİ -->
<div class="admin-panel-card">
    <h2>Kullanıcı Bilgileri</h2>

    <form action="" method="post" class="admin-form">

        <label>Kullanıcı Adı
            <input type="text" name="username" value="<?= htmlspecialchars($user['username']) ?>" required>
        </label>

        <label>E-posta
            <input type="email" name="email" value="<?= htmlspecialchars($user['email']) ?>" required>
        </label>

        <button type="submit" name="update_user" class="admin-btn-save">Bilgileri Güncelle</button>
    </form>
</div>

<!-- ŞİFRE -->
<div class="admin-panel-card">
    <h2>Şifre İşlemleri</h2>

    <form action="" method="post">
        <button type="submit" name="reset_password" class="admin-btn-warning"
            onclick="return confirm('Şifre 123456 yapılsın mı?');">
            Şifreyi Sıfırla
        </button>
    </form>
</div>

<!-- EVREN BİLGİSİ -->
<div class="admin-panel-card">
    <h2>Oyun Evreni Bilgisi</h2>

    <table class="admin-table">
        <thead>
            <tr>
                <th>Evren</th>
                <th>Durum</th>
                <th>Oyun ID</th>
                <th>Kullanıcı Adı</th>
                <th>Puan</th>
                <th>Sıra</th>
            </tr>
        </thead>

        <tbody>
        <?php foreach ($allUniverses as $uni): ?>
    
            <?php 
                $uid = $uni['id'];
                $hasAccount = isset($userUniverseMap[$uid]);
            ?>

            <tr>
                <td><?= htmlspecialchars($uni['name']) ?></td>

                <?php if ($hasAccount): 
                    $uv  = $userUniverseMap[$uid];
                    $dbName = $uni['db_name'];

                    // Oyun hesabını çek
                    $stmt2 = $db->prepare("
                        SELECT id, username, points, rank
                        FROM {$dbName}.uni{$uid}_users
                        WHERE id = ?
                    ");
                    $stmt2->execute([$uv['game_user_id']]);
                    $g = $stmt2->fetch();
                ?>

                <td style="color:#3aa83a;">Kayıtlı</td>
                <td><?= $g['id'] ?></td>
                <td><?= htmlspecialchars($g['username']) ?></td>
                <td><?= number_format($g['points']) ?></td>
                <td><?= $g['rank'] ?></td>

                <?php else: ?>

                <td style="color:#c00;">Kayıt Yok</td>
                <td>-</td>
                <td>-</td>
                <td>-</td>
                <td>-</td>

                <?php endif; ?>
            </tr>

        <?php endforeach; ?>
        </tbody>
    </table>
</div>


<!-- KULLANICI SİL -->
<div class="admin-panel-card">
    <h2>Kullanıcıyı Sil</h2>

    <form action="" method="post">
        <button type="submit" name="delete_user" class="admin-btn-danger"
            onclick="return confirm('Kullanıcıyı SİLMEK istediğine emin misin?');">
            Kullanıcıyı Sil
        </button>
    </form>
</div>

</main>
</div>
</body>
</html>
