<?php
// /portal/includes/Logger.php

class Logger
{
    private static string $logDir = __DIR__ . '/../logs/';

    public static function write(string $type, string $message, int $userId = 0): void
    {
        if (!is_dir(self::$logDir)) {
            mkdir(self::$logDir, 0777, true);
        }

        $file = self::$logDir . date('Y-m-d') . '.log';

        $time = date('H:i:s');
        $ip   = $_SERVER['REMOTE_ADDR'] ?? 'unknown';

        $log  = "[$time][$type][UID:$userId][IP:$ip] $message" . PHP_EOL;

        file_put_contents($file, $log, FILE_APPEND);
    }
}
