<?php
// portal/pages/play.php

require_once __DIR__ . '/../includes/auth.php';
require_once __DIR__ . '/../includes/db.php';
require_once __DIR__ . '/../config.php';

if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

if (empty($_SESSION['portal_user'])) {
    header("Location: index.php?page=login");
    exit;
}

$portalUser   = $_SESSION['portal_user'];
$portalUserId = (int)$portalUser['id'];

$db = DB::get();

$universeId = isset($_GET['universe']) ? (int)$_GET['universe'] : 0;
if ($universeId <= 0) {
    die("Geçersiz evren.");
}

// Evren bilgileri
$stmt = $db->prepare("SELECT * FROM portal_universes WHERE id = ?");
$stmt->execute([$universeId]);
$universe = $stmt->fetch();

if (!$universe) {
    die("Evren bulunamadı.");
}

$gameDBName = $universe['db_name'];
if (empty($gameDBName)) {
    die("Evren için oyun veritabanı adı (db_name) tanımlanmamış.");
}

// Oyun DB bağlantısı
$dsn = "mysql:host=" . DB_HOST . ";dbname=" . $gameDBName . ";charset=utf8mb4;port=" . DB_PORT;

try {
    $gameDB = new PDO($dsn, DB_USER, DB_PASS, [
        PDO::ATTR_ERRMODE            => PDO::ERRMODE_EXCEPTION,
        PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC
    ]);
} catch (Exception $e) {
    die("Oyun veritabanına bağlanılamadı: " . $e->getMessage());
}

// ✅ Universe'e göre tablo adı
$tableUsers   = "uni{$universeId}_users";
$tablePlanets = "uni{$universeId}_planets";

// Bu evrende portal->oyun eşleşmesi var mı?
$stmt = $db->prepare("
    SELECT * FROM portal_user_universe_accounts
    WHERE portal_user_id = ? AND universe_id = ?
    LIMIT 1
");
$stmt->execute([$portalUserId, $universeId]);
$account = $stmt->fetch();

$gameUserId = null;

if ($account) {
    // Eşleşme var -> direkt kullan
    $gameUserId = (int)$account['game_user_id'];
} else {
    // ✅ Eşleşme yok -> önce oyunda var olan kullanıcıyı bulmayı dene
    $username = $portalUser['username'];
    $email    = $portalUser['email'];

    // 1) portal_user_id ile ara
    $stmtFind = $gameDB->prepare("SELECT id FROM {$tableUsers} WHERE portal_user_id = ? LIMIT 1");
    $stmtFind->execute([$portalUserId]);
    $row = $stmtFind->fetch();

    if ($row) {
        $gameUserId = (int)$row['id'];
    } else {
        // 2) email ile ara
        $stmtFind = $gameDB->prepare("SELECT id FROM {$tableUsers} WHERE email = ? LIMIT 1");
        $stmtFind->execute([$email]);
        $row = $stmtFind->fetch();

        if ($row) {
            $gameUserId = (int)$row['id'];
        } else {
            // 3) username ile ara
            $stmtFind = $gameDB->prepare("SELECT id FROM {$tableUsers} WHERE username = ? LIMIT 1");
            $stmtFind->execute([$username]);
            $row = $stmtFind->fetch();

            if ($row) {
                $gameUserId = (int)$row['id'];
            }
        }
    }

    if ($gameUserId) {
        // ✅ Var olan oyun hesabı bulundu -> portal_user_id'yi yaz ve mapping oluştur
        $stmtUpd = $gameDB->prepare("UPDATE {$tableUsers} SET portal_user_id = ? WHERE id = ?");
        $stmtUpd->execute([$portalUserId, $gameUserId]);

        $stmtIns = $db->prepare("
            INSERT INTO portal_user_universe_accounts (portal_user_id, universe_id, game_user_id)
            VALUES (?, ?, ?)
        ");
        $stmtIns->execute([$portalUserId, $universeId, $gameUserId]);
    } else {
        // ❌ Oyun hesabı yok -> YENİ oluştur
        $ip       = $_SERVER['REMOTE_ADDR'] ?? '0.0.0.0';
        $timezone = "Europe/Istanbul";

        // Portal rolüne göre authlevel (opsiyonel)
        $authlevel = 0;
        if (!empty($portalUser['role']) && $portalUser['role'] === 'admin') {
            $authlevel = 3; // istersen 1/2/3 sistemine göre ayarla
        }

        $passwordRaw  = bin2hex(random_bytes(10));
        $passwordHash = sha1($passwordRaw); // SteemNova sha1 formatı

        // users insert (✅ portal_user_id dahil)
        $stmtUser = $gameDB->prepare("
            INSERT INTO {$tableUsers}
            (username, password, email, email_2, lang, authlevel, rights,
             galaxy, system, planet, universe,
             user_lastip, ip_at_reg, register_time, onlinetime, timezone,
             portal_user_id)
            VALUES
            (?, ?, ?, '', 'tr', ?, '',
             1, 1, 1, ?,
             ?, ?, UNIX_TIMESTAMP(), UNIX_TIMESTAMP(), ?,
             ?)
        ");

        $stmtUser->execute([
            $username,
            $passwordHash,
            $email,
            $authlevel,
            $universeId,
            $ip,
            $ip,
            $timezone,
            $portalUserId
        ]);

        $gameUserId = (int)$gameDB->lastInsertId();

        // Başlangıç gezegeni
        $galaxy = 1;
        $system = rand(1, 250);
        $planet = rand(1, 15);

        $planetName = $username . "'in Gezegeni";

        $stmtPlanet = $gameDB->prepare("
            INSERT INTO {$tablePlanets}
            (name, id_owner, universe, galaxy, system, planet, planet_type, last_update, image)
            VALUES
            (?, ?, ?, ?, ?, ?, 1, UNIX_TIMESTAMP(), 'normaltempplanet01')
        ");

        $stmtPlanet->execute([
            $planetName,
            $gameUserId,
            $universeId,
            $galaxy,
            $system,
            $planet
        ]);

        $planetId = (int)$gameDB->lastInsertId();

        $stmtUpdateUser = $gameDB->prepare("
            UPDATE {$tableUsers}
            SET id_planet = ?
            WHERE id = ?
        ");
        $stmtUpdateUser->execute([$planetId, $gameUserId]);

        // Portal mapping
        $stmt = $db->prepare("
            INSERT INTO portal_user_universe_accounts (portal_user_id, universe_id, game_user_id)
            VALUES (?, ?, ?)
        ");
        $stmt->execute([$portalUserId, $universeId, $gameUserId]);
    }
}

// SSO token oluştur
$token = bin2hex(random_bytes(32));

$stmtToken = $gameDB->prepare("
    INSERT INTO portal_login_tokens (token, portal_user_id, universe_id, game_user_id, created_at)
    VALUES (?, ?, ?, ?, NOW())
");
$stmtToken->execute([$token, $portalUserId, $universeId, $gameUserId]);

// 🔥 KESİN YÖNLENDİRME – index.php ASLA çağrılmasın
header('Location: ' . rtrim($universe['base_url'], '/') . '/game.php?page=overview');
exit;

