<?php
require_once __DIR__ . '/../includes/auth.php';
require_once __DIR__ . '/../includes/db.php';
require_once __DIR__ . '/../includes/mailer.php'; // PHPMailer fonksiyonumuz

$message = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    $username  = trim($_POST['username']);
    $email     = trim($_POST['email']);
    $password  = $_POST['password'];
    $password2 = $_POST['password2'];

    // --- FORM KONTROLLERİ ---
    if ($password !== $password2) {
        $message = 'Şifreler eşleşmiyor.';
    } elseif (strlen($password) < 5) {
        $message = 'Şifre en az 5 karakter olmalı.';
    } else {

        // Kullanıcı oluştur
        $result = Auth::register($username, $email, $password);

        if (isset($result['success'])) {

            // Auth artık user_id döndürüyor — ÖNEMLİ!
            if (empty($result['user_id'])) {
                $message = "Sistem hatası: user_id döndürülmedi.";
            } else {

                $db     = DB::get();
                $userId = $result['user_id'];

                // Doğrulama tokeni oluştur
                $token = bin2hex(random_bytes(32));

                $stmt = $db->prepare("
                    UPDATE portal_users 
                    SET email_verify_token = ?, email_verified = 0
                    WHERE id = ?
                ");
                $stmt->execute([$token, $userId]);

                // Doğrulama linki
                $verifyLink = "https://novapus.com/portal/verify_email.php?token=" . $token;

                // Doğrulama maili gönder
                $mailResult = sendVerificationMail($email, $username, $verifyLink);

                if (!$mailResult) {
                    $message = "Hesap oluşturuldu ancak doğrulama maili gönderilemedi. Lütfen destek ile iletişime geç.";
                } else {
                    // BAŞARILI → Profile yönlendir
                    header("Location: index.php?page=profile&verify_pending=1");
                    exit;
                }
            }

        } else {
            // Auth::register Hata mesajı döndürdü
            $message = $result['error'] ?? 'Bilinmeyen bir hata oluştu.';
        }
    }
}

require __DIR__ . '/../includes/header.php';
?>

<section class="section narrow">
    <h2>Yeni Hesap Oluştur</h2>
    <p>Tek portal hesabı ile tüm Novapus evrenlerinde oynayabilirsin.</p>

    <?php if (!empty($message)): ?>
        <div class="form-error"><?= htmlspecialchars($message) ?></div>
    <?php endif; ?>

    <form method="post" action="" class="form-card">

        <label class="form-label">
            Komutan Adı
            <input type="text" name="username" class="form-input" required>
        </label>

        <label class="form-label">
            E-posta
            <input type="email" name="email" class="form-input" required>
        </label>

        <label class="form-label">
            Şifre
            <input type="password" name="password" class="form-input" required>
        </label>

        <label class="form-label">
            Şifre (Tekrar)
            <input type="password" name="password2" class="form-input" required>
        </label>

        <button type="submit" class="btn btn-primary w-100">Kayıt Ol</button>

        <div class="form-bottom-text">
            Zaten hesabın var mı?
            <a href="index.php?page=login">Giriş yap</a>
        </div>
    </form>
</section>

<?php require __DIR__ . '/../includes/footer.php'; ?>
