<?php
require_once __DIR__ . '/../includes/db.php';

$db = DB::get();
$token = $_GET['token'] ?? '';
$message = '';

$stmt = $db->prepare("
    SELECT id FROM portal_users
    WHERE reset_token = ?
    AND reset_expires > NOW()
");
$stmt->execute([$token]);
$user = $stmt->fetch();

if (!$user) {
    die("Geçersiz veya süresi dolmuş bağlantı.");
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $pass1 = $_POST['password'] ?? '';
    $pass2 = $_POST['password2'] ?? '';

    if ($pass1 && $pass1 === $pass2) {
        $hash = password_hash($pass1, PASSWORD_DEFAULT);

        $stmt = $db->prepare("
            UPDATE portal_users
            SET password = ?, reset_token = NULL, reset_expires = NULL
            WHERE id = ?
        ");
        $stmt->execute([$hash, $user['id']]);

        header("Location: index.php?page=login&reset=1");
        exit;
    } else {
        $message = "Şifreler uyuşmuyor.";
    }
}
?>

<div class="login-box">
    <h3>Yeni Şifre Belirle</h3>

    <?php if ($message): ?>
        <div class="alert"><?= htmlspecialchars($message) ?></div>
    <?php endif; ?>

    <form method="post">
        <input type="password" name="password" placeholder="Yeni şifre" required>
        <input type="password" name="password2" placeholder="Yeni şifre (tekrar)" required>
        <button type="submit">Şifreyi Güncelle</button>
    </form>
</div>
