<?php

class BonusEngine
{
    /**
     * Kullanıcının tüm aktif subay bonuslarını döndürür.
     * return array('mine_metal' => 0.10, 'fleet_speed' => 0.20 ...)
     */
    public static function getAllBonuses($userId)
    {
        require_once __DIR__ . '/PlayerUtil.class.php';

        $bonuses = PlayerUtil::getOfficerBonuses($userId);

        if (!is_array($bonuses)) {
            return [];
        }

        return $bonuses;
    }


    /**
     * Bonus uygula
     * örn: applyBonus(1000, 0.10) => 1100
     */
    public static function applyBonus($value, $bonus)
    {
        if (empty($bonus)) {
            return $value;
        }

        return $value + ($value * $bonus);
    }


    /**
     * Bonus key ile direkt uygulama
     * örn: applyKeyBonus(1000, 'mine_metal', userID)
     */
    public static function applyKeyBonus($value, $key, $userId)
    {
        $bonuses = self::getAllBonuses($userId);

        if (!isset($bonuses[$key])) {
            return $value;
        }

        return self::applyBonus($value, $bonuses[$key]);
    }
}
