<?php

/**
 *  2Moons
 *   by Jan-Otto Kröpke 2009-2016
 *
 * @package 2Moons
 * @author Jan-Otto Kröpke <slaver7@gmail.com>
 * @licence MIT
 * @version 1.8.x Koray Karakuş <koraykarakus@yahoo.com>
 * @link https://github.com/jkroepke/2Moons
 */

class ShowOfficierPage extends AbstractGamePage
{
    public static $requireModule = 0;

    function __construct()
    {
        parent::__construct();
    }

    /**
     * Eski DM ekstraları (dmfunc) aynen korunuyor.
     */
    public function UpdateExtra($Element)
    {
        global $PLANET, $USER, $resource, $pricelist;

        $costResources = BuildFunctions::getElementPrice($USER, $PLANET, $Element);

        if (!BuildFunctions::isElementBuyable($USER, $PLANET, $Element, $costResources)) {
            return;
        }

        $USER[$resource[$Element]] = max($USER[$resource[$Element]], TIMESTAMP) + $pricelist[$Element]['time'];

        if (isset($costResources[901])) { $PLANET[$resource[901]] -= $costResources[901]; }
        if (isset($costResources[902])) { $PLANET[$resource[902]] -= $costResources[902]; }
        if (isset($costResources[903])) { $PLANET[$resource[903]] -= $costResources[903]; }
        if (isset($costResources[921])) { $USER[$resource[921]]   -= $costResources[921]; }

        $sql = 'UPDATE %%USERS%% SET
                ' . $resource[$Element] . ' = :newTime
            WHERE
                id = :userId;';

        Database::get()->update($sql, array(
            ':newTime' => $USER[$resource[$Element]],
            ':userId'  => $USER['id']
        ));
    }

    /**
     * YENİ SUBAY SATIN ALMA
     *
     * $Element       = subay ID (uni1_officers.id)
     * $_POST['days'] = 7 / 30 / 90
     */
    public function UpdateOfficier($Element)
    {
        global $USER, $resource;

        $db = Database::get();

        // Seçilen paket süresi
        $days = (int)HTTP::_GP('days', 0);
        if (!in_array($days, array(7, 30, 90), true)) {
            return;
        }

        // Subay kaydını çek
        $officer = $db->selectSingle(
            'SELECT * FROM uni1_officers WHERE id = :id AND active = 1;',
            array(':id' => $Element)
        );

        if (empty($officer)) {
            // Böyle bir subay yok veya pasif
            return;
        }

        // cost_dm'yi 30 günlük fiyat kabul ediyoruz
        $baseCost = (int)$officer['cost_dm'];

        switch ($days) {
            case 7:
                $costDM = (int)round($baseCost / 3);      // örn: 1500 ise ~500
            break;
            case 30:
                $costDM = $baseCost;                       // 30 gün
            break;
            case 90:
            default:
                $costDM = (int)round($baseCost * 7 / 3);   // ~2.33 katı
            break;
        }

        // Dark Matter alanı (genelde 'darkmatter')
        $darkMatterKey = isset($resource[921]) ? $resource[921] : 'darkmatter';

        // Yeterli DM var mı?
        if ($costDM <= 0 || !isset($USER[$darkMatterKey]) || $USER[$darkMatterKey] < $costDM) {
            return;
        }

        /* ============================================
           SÜRE HESABI (BASİT VE SABİT)
        ============================================ */

        $addSeconds = $days * 86400;
        $now        = TIMESTAMP;

        // Kullanıcının bu subayı var mı?
        $userOfficer = $db->selectSingle(
            'SELECT expire_time FROM uni1_users_officers WHERE user_id = :userId AND officer_id = :officerId;',
            array(
                ':userId'    => $USER['id'],
                ':officerId' => $officer['id'],
            )
        );

        if (!empty($userOfficer) && $userOfficer['expire_time'] > $now) {
            // Süresi dolmamış ise üzerine ekle
            $expireTime = $userOfficer['expire_time'] + $addSeconds;
        } else {
            // Yoksa veya süresi dolmuşsa yeniden başlat
            $expireTime = $now + $addSeconds;
        }

        // UPSERT
        $sql = 'INSERT INTO uni1_users_officers SET
                    user_id     = :userId,
                    officer_id  = :officerId,
                    expire_time = :expireTime
                ON DUPLICATE KEY UPDATE
                    expire_time = :expireTime;';

        $db->insert($sql, array(
            ':userId'     => $USER['id'],
            ':officerId'  => $officer['id'],
            ':expireTime' => $expireTime,
        ));

        // DM düş
        $USER[$darkMatterKey] -= $costDM;

        $db->update(
            'UPDATE %%USERS%% SET ' . $darkMatterKey . ' = :dm WHERE id = :userId;',
            array(
                ':dm'     => $USER[$darkMatterKey],
                ':userId' => $USER['id'],
            )
        );
    }

    public function show()
    {
        global $USER, $PLANET, $resource, $reslist, $LNG, $pricelist;

        $updateID = HTTP::_GP('id', 0);

        // Satın alma işlemleri
        if (!empty($updateID) && $_SERVER['REQUEST_METHOD'] === 'POST' && $USER['urlaubs_modus'] == 0)
        {
            // Önce DM ekstralarını kontrol et (eski sistem)
            if (isModuleAvailable(MODULE_DMEXTRAS) && isset($reslist['dmfunc']) && in_array($updateID, $reslist['dmfunc'])) {
                $this->UpdateExtra($updateID);
            }
            // Sonra yeni subay sistemi
            elseif (isModuleAvailable(MODULE_OFFICIER)) {
                $this->UpdateOfficier($updateID);
            }
        }

        $darkmatterList = array();
        $officierList   = array();

        // ========= DM EXTRAS (ESKİ) =========
        if (isModuleAvailable(MODULE_DMEXTRAS) && !empty($reslist['dmfunc']))
        {
            foreach ($reslist['dmfunc'] as $Element)
            {
                if ($USER[$resource[$Element]] > TIMESTAMP) {
                    $this->tplObj->execscript("GetOfficerTime(" . $Element . ", " . ($USER[$resource[$Element]] - TIMESTAMP) . ");");
                }

                $costResources = BuildFunctions::getElementPrice($USER, $PLANET, $Element);
                $buyable       = BuildFunctions::isElementBuyable($USER, $PLANET, $Element, $costResources);
                $costOverflow  = BuildFunctions::getRestPrice($USER, $PLANET, $Element, $costResources);
                $elementBonus  = BuildFunctions::getAvalibleBonus($Element);

                $timeLeft = max($USER[$resource[$Element]] - TIMESTAMP, 0);

$darkmatterList[$Element] = array(
    'timeLeft'      => $timeLeft,

    // ✅ TEMPLATE SAFE
    'isActive'      => ($timeLeft > 0) ? 1 : 0,
    'hasActive'     => ($timeLeft > 0) ? 1 : 0,

    'costResources' => $costResources,
    'buyable'       => $buyable,
    'time'          => $pricelist[$Element]['time'],
    'costOverflow'  => $costOverflow,
    'elementBonus'  => $elementBonus,
);

            }
        }

        // ========= YENİ SUBAY SİSTEMİ (DB TABANLI) =========
        if (true)
        {
            $db = Database::get();

            // Tüm aktif subayları ve kullanıcının sahip olduğu süreleri çek
            $officers = $db->select(
                'SELECT o.*, uo.expire_time
                 FROM uni1_officers o
                 LEFT JOIN uni1_users_officers uo
                   ON uo.officer_id = o.id
                  AND uo.user_id    = :userId
                WHERE o.active = 1
                ORDER BY o.id ASC;',
                array(':userId' => $USER['id'])
            );

            $darkMatterKey = isset($resource[921]) ? $resource[921] : 'darkmatter';
            $userDM        = isset($USER[$darkMatterKey]) ? (int)$USER[$darkMatterKey] : 0;

            foreach ($officers as $row)
            {
                $expireTime = !empty($row['expire_time']) ? (int)$row['expire_time'] : 0;
                $timeLeft   = $expireTime > 0 ? max($expireTime - TIMESTAMP, 0) : 0;

                // ✅ TEMPLATE'İN İSTEDİĞİ ALANLAR (PHP 8.2 SAFE)
                $isActive  = ($timeLeft > 0) ? 1 : 0;
                $hasActive = $isActive; // template "hasActive" bekliyor

                // Subayın bonuslarını çek
                $bonuses = $db->select(
                    'SELECT effect_key, effect_value
                     FROM uni1_officer_effects
                     WHERE officer_id = :officerId;',
                    array(':officerId' => $row['id'])
                );

                $elementBonus = array();
                foreach ($bonuses as $bonusRow) {
                    $elementBonus[] = array(
                        'key'   => $bonusRow['effect_key'],
                        'value' => $bonusRow['effect_value'],
                    );
                }

                // Paket fiyatlarını hesapla (7 / 30 / 90 gün)
                $baseCost = (int)$row['cost_dm'];

                $packs = array(
                    array(
                        'days'    => 7,
                        'cost'    => (int)round($baseCost / 3),
                    ),
                    array(
                        'days'    => 30,
                        'cost'    => $baseCost,
                    ),
                    array(
                        'days'    => 90,
                        'cost'    => (int)round($baseCost * 7 / 3),
                    ),
                );

                // ✅ pack'lere "buyable" ekle + genel uygun paket var mı
                $hasAffordablePack = 0;
                foreach ($packs as $k => $p) {
                    $buyablePack = ((int)$p['cost'] > 0 && $userDM >= (int)$p['cost']) ? 1 : 0;
                    $packs[$k]['buyable'] = $buyablePack;
                    if ($buyablePack) {
                        $hasAffordablePack = 1;
                    }
                }

                $officierList[$row['id']] = array(
                    'id'               => (int)$row['id'],
                    'name'             => $row['name'],
                    'description'      => $row['description'],
                    'image'            => $row['image'],

                    'timeLeft'         => $timeLeft,

                    // ✅ eklenen alanlar (Undefined array key fix)
                    'isActive'         => $isActive,
                    'hasActive'        => $hasActive,

                    // opsiyonel ama işe yarar
                    'hasAffordablePack'=> $hasAffordablePack,

                    'elementBonus'     => $elementBonus,
                    'packs'            => $packs,
                );
            }
        }

        $this->assign(array(
    'officierList'   => $officierList,
    'darkmatterList' => $darkmatterList,

    // ✅ GLOBAL GARANTİ (PHP 8.2 SAFE)
    'hasActive'      => false,

    'of_dm_trade'    => sprintf($LNG['of_dm_trade'], $LNG['tech'][921]),
));


        $this->display('page.officier.default.tpl');
    }
}
