<?php
/**
 *  2Moons
 *   by Jan-Otto Kröpke 2009-2016
 *
 * For the full copyright and license information, please view the LICENSE
 *
 * @package 2Moons
 * @author Jan-Otto Kröpke <slaver7@gmail.com>
 * @copyright 2009 Lucky
 * @copyright 2016 Jan-Otto Kröpke <slaver7@gmail.com>
 * @licence MIT
 * @version 1.8.x Koray Karakuş <koraykarakus@yahoo.com>
 * @link https://github.com/jkroepke/2Moons
 */

// Translated into English by QwataKayean . All rights reversed (C) 2012
// 2Moons - Copyright (C) 2010-2012 Slaver
// Grammar Pedantry fixes @etaletai 2018

//MODULE_FLIGHT_SIMULATOR
$LNG['lm_flight_simulator'] = "Flight Sim";
$LNG['fs_flight_sim'] = "Flight Sim.";
$LNG['fs_time'] = "time";
$LNG['fs_percantage'] = "%";
$LNG['fs_time_hours'] = "hours";
$LNG['fs_time_seconds'] = "seconds";
$LNG['fs_time_minutes'] = "minutes";

//MODULE_COLLECT_MINES
$LNG['cm_error_1'] = "Mines cannot be collected in vacation mode !";
$LNG['cm_error_2'] = "Mines cannot be collected under attack !";
$LNG['cm_error_3'] = "You need to wait %s minutes before next !";
$LNG['cm_collect_mines_submit'] = "Collect Mines!";

//MODULE_AUTOEXPEDITION
$LNG['ae_autoexp'] = "Auto Expedition";
$LNG['ae_galaxy'] = "Galaxy";
$LNG['ae_system'] = "System";
$LNG['ae_planet'] = "Planet";
$LNG['ae_settings'] = "Settings";
$LNG['ae_send'] = "Send expedition!";
$LNG['ae_error_1'] = "Not enough expedition slot !";
$LNG['ae_error_2'] = "Expedition is not possible on vacation mode !";
$LNG['ae_error_3'] = "Recaptcha is wrong !";
$LNG['ae_error_4'] = "No fleets found !";
$LNG['ae_success'] = "Fleet(s) sent to expedition mission, successfully";
//relocate module

$LNG['cannot_use_in_vac'] = "You cannot use this option in vacation mode";
$LNG['rl_relocate'] = "relocate";
$LNG['rl_info'] = "You need %s Dark Matter to move your planet / moon !";
$LNG['rl_error_type_1'] = "You didn't enter coordinates correctly";
$LNG['rl_error_type_2'] ="Relocation should be started from Planet";
$LNG['rl_error_type_3'] ="Position is not free";
$LNG['rl_error_type_4'] ="Wrong possition !";
$LNG['rl_error_type_5'] ="You cannot move planet if there is a building in construction !";
$LNG['rl_error_type_6'] ="You cannot move planet if there is a research started from planet !";
$LNG['rl_error_type_7'] ="There is fleet movement which is started from this planet, you cannot relocate !";
$LNG['rl_error_type_8'] ="Same planet can be moved once in every %s hours";
$LNG['rl_error_type_9'] = "You cannot move planet if there is a construction in shipyard !";
$LNG['rl_error_type_10'] = "You cannot move planet if the planet is under attack !";
$LNG['rl_error_type_11'] = "Not Enough Dark Matter !";
$LNG['rl_success'] = "Your planet was teleported to the following coordinates: ";
$LNG['lm_relocate'] = "Relocate";


//main.topnav.tpl//

$LNG['resource_available'] = "Available";
$LNG['resource_capacity'] = "Storage Capacity";
$LNG['resource_production'] = "Production";
$LNG['energy_available'] = "Available Energy";
$LNG['energy_used'] = "Used Energy";
$LNG['energy_produced'] = "Produced Energy";
$LNG['darkmatter_available'] = "Current Darkmatter";

//-------------------- fleetTable.tpl  ------------------//

$LNG['fm_no_fleet_movements'] = "No Fleet Movements";
$LNG['fm_fleets'] = "Fleets";

//------------------------------------------------------//

//-------------------- MODULE 45 UNIVERSE INFORMATION ------------------//

$LNG['si_universe_info'] = "Universe Info";
$LNG['si_game_speed'] = "Game Speed";
$LNG['si_fleet_speed'] = "Fleet Speed";
$LNG['si_production_speed'] = "Production Speed";
$LNG['si_storage_multiplier'] = "Storage Multiplier";


//---------------------------------------------------------------------//

$LNG['Messages']							= 'Messages';

$LNG['PM']									= '[PM]';
$LNG['write_message']						= 'Write message';

$LNG['ready']								= 'Ready';

$LNG['loading']								= 'Loading ...';

$LNG['invalid_action']						= 'Action Invalid!';

$LNG['type_mission_1']  					= 'Attack';
$LNG['type_mission_2']  					= 'ACS - Attack on cooperation';
$LNG['type_mission_3']  					= 'Transport';
$LNG['type_mission_4']  					= 'Deploy';
$LNG['type_mission_5']  					= 'Hold';
$LNG['type_mission_6']  					= 'Spying';
$LNG['type_mission_7']  					= 'Colonize';
$LNG['type_mission_8']  					= 'Recycle';
$LNG['type_mission_9']  					= 'Destroy';
$LNG['type_mission_10']  					= 'Missile attack';
$LNG['type_mission_11']  					= 'Research Dark matter ';
$LNG['type_mission_15'] 					= 'Expedition';
$LNG['type_mission_16'] 					= 'Trade';
$LNG['type_mission_17'] 					= 'Transfer';

$LNG['type_planet_1']  					= 'Planet';
$LNG['type_planet_2']  					= 'Debris Field';
$LNG['type_planet_3']  					= 'Moon';

$LNG['user_level_0']                        = 'Player';
$LNG['user_level_1']                        = 'Moderator';
$LNG['user_level_2']                        = 'Operator';
$LNG['user_level_3']                        = 'Administrator';


$LNG['page_doesnt_exist']					= 'This page does not exist';
$LNG['bad_forum_url']				    	= 'The Forum link is incorrect!';
$LNG['admin_access_1']				    	= 'Players have temporary administrative permissions.';
$LNG['admin_access_link']				    = 'Disable this access';
$LNG['admin_access_2']				    	= ", If you don't need it any longer";


//----------------------------------------------------------------------------//
// Topnav
$LNG['tn_vacation_mode']					= "Your account is in vacation mode";
$LNG['tn_delete_mode']						= 'The account at %s will be deleted!';

//----------------------------------------------------------------------------//
// Menu
$LNG['lm_changelog']						= 'Changelog';
$LNG['lm_overview']							= 'Overview';
$LNG['lm_galaxy']							= 'Galaxy';
$LNG['lm_empire']							= 'Empire';
$LNG['lm_fleet']							= 'Fleet';
$LNG['lm_buildings']						= 'Buildings';
$LNG['lm_research']							= 'Research';
$LNG['lm_shipshard']						= 'Hangar';
$LNG['lm_defenses']							= 'Defenses';
$LNG['lm_marketplace']						= 'Marketplace';
$LNG['lm_resources']						= 'Resources';
$LNG['lm_officiers']						= 'Officers';
$LNG['lm_trader']							= 'Market';
$LNG['lm_fleettrader']						= 'Merchant of Fleets';
$LNG['lm_technology']						= 'Technologies';
$LNG['lm_messages']							= 'Messages';
$LNG['lm_alliance']							= 'Alliance';
$LNG['lm_buddylist']						= 'Friends';
$LNG['lm_notes']							= 'Notes';
$LNG['lm_statistics']						= 'Statistics';
$LNG['lm_search']							= 'Search';
$LNG['lm_options']							= 'Options';
$LNG['lm_banned']							= 'Banned';
$LNG['lm_forums']							= 'Forum';
$LNG['lm_logout']							= 'Logout';
$LNG['lm_administration']					= 'Administration';
$LNG['lm_queue']							= 'Queues';
$LNG['lm_topkb']							= 'Hall of Fame';
$LNG['lm_faq']								= 'FAQ';
$LNG['lm_records']							= 'Records';
$LNG['lm_chat']								= 'Chat';
$LNG['lm_support']							= 'Support';
$LNG['lm_rules']							= 'Rules';
$LNG['lm_battlesim']						= 'Simulator';
$LNG['lm_playercard']                       = 'Player Profile';
$LNG['lm_info']                     		= 'Info';
$LNG['lm_disclamer']						= 'Credits';


//------------------------------------------------ ----------------------------//
// Planet Menu

$LNG['pm_diameter'] = "Diameter";
$LNG['pm_min_temperature'] = "Minimum Temperature";
$LNG['pm_max_temperature'] = "Maximum Temperature";
$LNG['pm_fields'] = "Fields";

//----------------------------------------------------------------------------//
// Overview

$LNG['ov_newname_specialchar']				= 'For names of planets, use only numbers, letters, spaces, _,-,.';
$LNG['ov_newname_done']						= 'Planet renamed!';
$LNG['ov_planet_abandoned']					= 'The planet was destroyed!';
$LNG['ov_principal_planet_cant_abanone']	= 'You can not delete the main planet!';
$LNG['ov_abandon_planet_not_possible']		= 'Planets cannot be deleted during activities.';
$LNG['ov_wrong_pass']						= 'Password incorrect!';
$LNG['ov_wrong_name']						= 'Name incorrect!';
$LNG['ov_have_new_message']					= 'You have a new message';
$LNG['ov_have_new_messages']				= 'You have %d new messages';
$LNG['ov_planetmenu']						= 'Rename or delete';
$LNG['ov_free']								= 'Free';
$LNG['ov_news']								= 'News';
$LNG['ov_place']							= 'Position';
$LNG['ov_of']								= 'of';
$LNG['ov_planet']							= 'Planet';
$LNG['ov_server_time']						= 'Server time';
$LNG['ov_events']							= 'Activities';
$LNG['ov_diameter']							= 'Diameter';
$LNG['ov_distance_unit']					= 'km';
$LNG['ov_temperature']						= 'Temperature';
$LNG['ov_aprox']							= 'Approximately';
$LNG['ov_temp_unit']						= '°C';
$LNG['ov_to']								= 'to';
$LNG['ov_position']							= 'Position';
$LNG['ov_points']							= 'Points';
$LNG['ov_online']							= 'Online';
$LNG['ov_security_request']					= 'Security question';
$LNG['ov_security_confirm']					= 'Please confirm if you want to destroy the planet %s .';
$LNG['ov_password']							= 'Password';
$LNG['ov_delete_planet']					= 'Delete Planet';
$LNG['ov_planet_rename']					= 'Rename Planet';
$LNG['ov_rename_label']						= 'New name';
$LNG['ov_fields']							= 'Fields';
$LNG['ov_developed_fields']					= 'Fields used';
$LNG['ov_max_developed_fields']				= 'Max. Permitted fields';
$LNG['ov_fleet']							= 'Fleets';
$LNG['ov_admins_online']					= 'Active Admins';
$LNG['ov_no_admins_online']					= 'Currently, there is no administrator online';
$LNG['ov_userbanner']						= "Player's Banner";
$LNG['ov_userrank_info']					= '%s (%s <a href="game.php?page=statistics&amp;range=%d">%d</a> %s %s)';
$LNG['ov_teamspeak_not_online']				= 'The Teamspeak server is not active';
$LNG['ov_teamspeak']						= 'Teamspeak';
$LNG['ov_teamspeak_connect']				= 'Connect';
$LNG['ov_teamspeak_online']					= 'Online';
$LNG['ov_closed']							= 'The universe is currently disabled';
$LNG['ov_reflink']							= 'Recruits';
$LNG['ov_noreflink']						= 'You have not recruited any players yet';
$LNG['ov_chat_online']						= 'Players in chat:';
$LNG['ov_players']							= 'Players';
$LNG['ov_moving_fleets']					= 'Moving fleets';

//overview actions

$LNG['ov_ac_error_1'] = "Name cannot be empty !";
$LNG['ov_ac_error_2'] = "Planet name is too long !";
$LNG['ov_ac_error_3'] = "planet name is not entered !";

//----------------------------------------------------------------------------//
// Galaxy

$LNG['gl_no_deuterium_to_view_galaxy']		= 'You dont have enough deuterium to view the galaxy';
$LNG['gl_legend']							= 'Legend';
$LNG['gl_strong_player']					= 'Strong player';
$LNG['gl_week_player']						= 'Weak player';
$LNG['gl_vacation']							= 'Vacation mode';
$LNG['gl_banned']							= 'Banned / Suspended';
$LNG['gl_inactive_seven']					= '7 Inactive days';
$LNG['gl_inactive_twentyeight']				= '28 Inactive days';
$LNG['gl_short_enemy']						= '';
$LNG['gl_short_friend']						= '';
$LNG['gl_short_member']						= '';
$LNG['gl_short_strong']						= 'S';
$LNG['gl_short_newbie']						= 'N';
$LNG['gl_short_vacation']					= 'VM';
$LNG['gl_short_ban']						= 'B';
$LNG['gl_short_inactive']					= 'i';
$LNG['gl_short_long_inactive']				= 'I';
$LNG['gl_populed_planets']					= '%d Existing planets';
$LNG['gl_out_space']						= 'Deep galaxy';
$LNG['gl_avaible_missiles']					= 'Available Missiles';
$LNG['gl_fleets']							= 'Fleet Slots';
$LNG['gl_avaible_grecyclers']				= 'Giga Recycler';
$LNG['gl_avaible_recyclers']				= 'Recycler';
$LNG['gl_avaible_spyprobes']				= 'Spy Probes';
$LNG['gl_missil_launch']					= 'Launch Missiles';
$LNG['gl_missil_to_launch']					= 'Number of Missiles (<b>%d</b> disp.):';
$LNG['gl_all_defenses']						= 'All defenses';
$LNG['gl_objective']						= 'Main Objective';
$LNG['gl_missil_launch_action']				= 'Send';
$LNG['gl_galaxy']							= 'Galaxy';
$LNG['gl_solar_system']						= 'System';
$LNG['gl_show']								= 'View';
$LNG['gl_pos']								= 'Pos.';
$LNG['gl_planet']							= 'Planet';
$LNG['gl_name_activity']					= 'Name (Activity)';
$LNG['gl_moon']								= 'Moon';
$LNG['gl_debris']							= 'Debris';
$LNG['gl_player_estate']					= 'Player (State)';
$LNG['gl_alliance']							= 'Alliance';
$LNG['gl_actions']							= 'Actions';
$LNG['gl_spy']								= 'Spying';
$LNG['gl_buddy_request']					= 'Friend request';
$LNG['gl_missile_attack']					= 'Missile attack';
$LNG['gl_with']								= ' with ';
$LNG['gl_member']							= '%d Members';
$LNG['gl_member_add']						= '%d Member';
$LNG['gl_alliance_page']					= 'Page of the Alliance';
$LNG['gl_see_on_stats']						= 'Stats';
$LNG['gl_alliance_web_page']				= 'Webpage of Alliance';
$LNG['gl_debris_field']						= 'Debris Field';
$LNG['gl_collect']							= 'Recycle';
$LNG['gl_resources']						= 'Resources';
$LNG['gl_features']							= 'Properties';
$LNG['gl_diameter']							= 'Diameter';
$LNG['gl_temperature']						= 'Temperatura';
$LNG['gl_phalanx']							= 'Phalanx';
$LNG['gl_planet_destroyed']					= 'Planet destroyed';
$LNG['gl_playercard']						= 'Player profile';
$LNG['gl_in_the_rank']						= 'Player %s in pos. %d';
$LNG['gl_activity']							= '(*)';
$LNG['gl_activity_inactive']				= '(%d min)';
$LNG['gl_ajax_status_ok']					= 'Done';
$LNG['gl_ajax_status_fail']					= 'Error';
$LNG['gl_free_desc'] 						= 'This planet is habitable. Here is the ideal place to develop a new colony';
$LNG['gl_free'] 							= 'Free';
$LNG['gl_yes'] 								= 'Yes';
$LNG['gl_no'] 								= 'No';
$LNG['gl_points'] 							= 'Points';
$LNG['gl_player']							= 'Player';
$LNG['gl_to']								= 'to';
$LNG['gl_to']								= 'to';
$LNG['gl_trade_space']	= 'Trading zone';

//----------------------------------------------------------------------------//
// Sensor Phalanx
$LNG['px_no_deuterium']						= "You don't have enough deuterium!";
$LNG['px_scan_position']					= 'Investigate position';
$LNG['px_fleet_movement']					= 'Fleet in movement';
$LNG['px_no_fleet']							= 'There are no moving fleets.';
$LNG['px_out_of_range']						= 'Out of reach';

//----------------------------------------------------------------------------//
// Empire
$LNG['lv_imperium_title']					= 'Empire';
$LNG['lv_planet']							= 'Planet';
$LNG['lv_name']								= 'Name';
$LNG['lv_coords']							= 'Coordinates';
$LNG['lv_fields']							= 'Fields';
$LNG['lv_resources']						= 'Resources';
$LNG['lv_buildings']						= 'Buildings';
$LNG['lv_technology']						= 'Technologies';
$LNG['lv_ships']							= 'Ships';
$LNG['lv_defenses']							= 'Defenses';
$LNG['lv_total']							= 'Total';

//----------------------------------------------------------------------------//
// Fleet
$LNG['fl_returning']						= 'Fleet return';
$LNG['fl_onway']							= 'Fleet Target';
$LNG['fl_r']								= '(R)';
$LNG['fl_a']								= '(A)';
$LNG['fl_send_back']						= 'Return';
$LNG['fl_acs']								= 'ACS';
$LNG['fl_no_more_slots']					= 'No free slots';
$LNG['fl_speed_title']						= 'Speed: ';
$LNG['fl_continue']							= 'Continue';
$LNG['fl_no_ships']							= 'No ships available';
$LNG['fl_remove_all_ships']					= 'No ship';
$LNG['fl_select_all_ships']					= 'All ships';
$LNG['fl_fleets']							= 'Fleet';
$LNG['fl_expeditions']						= 'expedition';
$LNG['fl_number']							= 'ID';
$LNG['fl_mission']							= 'Mission';
$LNG['fl_ammount']							= 'Number';
$LNG['fl_beginning']						= 'Start';
$LNG['fl_departure']						= 'Arrival (Destination)';
$LNG['fl_destiny']							= 'Destination';
$LNG['fl_objective']						= 'Target';
$LNG['fl_arrival']							= 'Arrival (Return)';
$LNG['fl_info_detail']						= 'Details';
$LNG['fl_order']							= 'Order';
$LNG['fl_new_mission_title']				= 'New mission: Select fleet';
$LNG['fl_ship_type']						= 'Type of Ship';
$LNG['fl_ship_available']					= 'Ships available';
$LNG['fl_planet_shortcut']					= '(P)';
$LNG['fl_debris_shortcut']					= '(DF)';
$LNG['fl_moon_shortcut']					= '(M)';
$LNG['fl_no_shortcuts']						= 'No shortcuts';
$LNG['fl_register_shorcut']					= 'Create';
$LNG['fl_shortcuts']						= 'Shortcuts';
$LNG['fl_dlte_shortcut']					= 'Delete';
$LNG['fl_shortcut_add']						= 'Add';
$LNG['fl_shortcut_edition']					= 'Edit Shortcut';
$LNG['fl_shortcut_save']					= 'Save Shortcut';
$LNG['fl_shortcut_saved']					= 'Shortcut saved!';
$LNG['fl_no_colony']						= 'There is no colony';
$LNG['fl_send_fleet']						= 'Send fleet';
$LNG['fl_fleet_speed']						= 'Fleet speed';
$LNG['fl_distance']							= 'Distance';
$LNG['fl_shortcut_name']					= 'Name';
$LNG['fl_flying_time']					    = 'Time of Flying';
$LNG['fl_flying_arrival']					= 'Arrival';
$LNG['fl_flying_return']					= 'Return';
$LNG['fl_fuel_consumption']			        = 'Consumption of deuterium';
$LNG['fl_max_speed']						= 'Max Speed';
$LNG['fl_cargo_capacity']				    = 'Cargo capacity';
$LNG['fl_shortcut']							= 'Shortcuts';
$LNG['fl_my_planets']					    = 'My planets';
$LNG['fl_acs_title']						= 'Alliance attack';
$LNG['fl_hold_time']						= 'At Flying';
$LNG['fl_resources']						= 'Resources';
$LNG['fl_max']								= 'max';
$LNG['fl_min']								= 'min';
$LNG['fl_hours']                            = 'Hours';
$LNG['fl_resources_left']				    = 'Capacity avaliable';
$LNG['fl_all_resources']			        = 'All resources';
$LNG['fl_multi_alarm']						= 'Multi alarm!';
$LNG['fl_empty_target']						= 'No mission available (does this planet exist?)';
$LNG['fl_transfer_alert_message']		    = 'Attention! Your fleet will be transferred to different user!';
$LNG['fl_expedition_alert_message']		    = 'Attention! Explorations are dangerous missions, you can lose your fleet!';
$LNG['fl_dm_alert_message']                 = 'Beware, if in %s %s was found, destroyed the fleets!';
$LNG['fl_vacation_mode_active']			    = 'Vacation mode active';
$LNG['fl_expedition_fleets_limit']		    = 'No exploration slots avaliable!';
$LNG['fl_week_player']						= 'The player is under the protection of weak player';
$LNG['fl_strong_player']					= 'The player is too strong.';
$LNG['fl_in_vacation_player']				= 'The player is in vacation mode';
$LNG['fl_no_slots']							= 'Without slots avaliable';
$LNG['fl_planet_populed']					= 'This planet is populed!';
$LNG['fl_no_same_alliance']				    = 'The target player of the planet must be of your Alliance or be on your friends list!';
$LNG['fl_not_ally_deposit']				    = 'Dont have deposit of Alliance';
$LNG['fl_deploy_only_your_planets']			= 'You can only deploy fleets on your own planets!';
$LNG['fl_fleet_sended']						= 'Fleet sent';
$LNG['fl_from']								= 'From';
$LNG['fl_arrival_time']						= 'Target time';
$LNG['fl_return_time']						= 'Time of Return';
$LNG['fl_fleet']							= 'Fleet';
$LNG['fl_player']							= 'Player ';
$LNG['fl_add_to_attack']					= ' added to attack.';
$LNG['fl_already_invited']					= ' has been invited..';
$LNG['fl_dont_exist']						= ' does not exist.';
$LNG['fl_acs_invitation_message']			= ' invited to ACS.';
$LNG['fl_acs_invitation_title']				= 'ACS';
$LNG['fl_sac_of_fleet']						= 'ACS fleet';
$LNG['fl_modify_sac_name']					= 'ACS name';
$LNG['fl_members_invited']					= 'Guests';
$LNG['fl_invite_members']					= 'Invite members';
$LNG['fl_simulate']							= 'Simulate';
$LNG['fl_bonus']							= 'Bonus';
$LNG['fl_bonus_attack']						= 'Weapons';
$LNG['fl_bonus_defensive']					= 'Defense';
$LNG['fl_bonus_shield']						= 'Shield';
$LNG['fl_no_empty_derbis']					= 'Without debris present!';
$LNG['fl_acs_newname_alphanum']				= 'The ACS name must contain alphanumeric characters only';
$LNG['fl_acs_change']						= 'Change';
$LNG['fl_acs_change_name']					= 'Type the new name';
$LNG['fl_error_not_avalible']				= 'There is nothing at these coordinates!';
$LNG['fl_error_empty_derbis']				= "No debris fields!";
$LNG['fl_error_no_moon']					= 'No moon found at these coordinates!';
$LNG['fl_error_same_planet']				= 'Start and destination planet are identical!';
$LNG['fl_invalid_target']					= 'No valid target';
$LNG['fl_no_noresource']					= 'No raw materials loaded!';
$LNG['fl_resources']					= 'Raw materials loaded!';
$LNG['fl_no_target']						= 'No available target planet';
$LNG['fl_not_all_ship_avalible']			= 'Not all ships present.';
$LNG['fl_no_expedition_slot']				= "You can't start more expeditions!";
$LNG['fl_invalid_mission']					= 'Invalid mission';
$LNG['fl_bash_protection']					= 'This would violate the Bash Rule';
$LNG['fl_admin_attack']						= "You can't attack an administrator";
$LNG['fl_target_exists']					= 'Target planet';
$LNG['fl_target_not_exists']				= 'Target planet does not exist!';
$LNG['fl_only_planets_colonizable']			= 'Only planets can be colonized.';
$LNG['fl_player_is_noob']					= 'Player is in the Noob Protection!';
$LNG['fl_player_is_strong']					= 'Player is too strong!';
$LNG['fl_no_hold_depot']					= 'No Alliance Depot is located on the target.';
$LNG['fl_not_enough_deuterium']				= 'Not enough deuterium available.';
$LNG['fl_not_enough_space']					= 'You do not have enough cargo space available.';
$LNG['fl_hold_time_not_exists']				= 'Invalid retention time.';
$LNG['fl_system_places']					= 'Special locations';
$LNG['fl_no_noresource_exchange'] = 'No resources in exchange field';
$LNG['fl_own_planet_error']					= 'Error! Again select the planet from which you want to send the fleet.';
$LNG['fl_exchange'] = 'Exchange';
$LNG['fl_visibility'] = 'Visibility';
$LNG['fl_visibility_all'] = 'All';
$LNG['fl_visibility_alliance'] = 'Allies and trading partners';
$LNG['fl_visibility_no_enemies'] = 'All except enemies';
$LNG['fl_market_type'] = 'Market type';
$LNG['fl_mt_fleet'] = 'Fleet market';
$LNG['fl_mt_resources'] = 'Resource market';
$LNG['fl_stronger_techs'] = 'Your attack/defensive/shield are too low.';
//----------------------------------------------------------------------------//
// Buildings
$LNG['bd_dismantle']						= 'Demolish';
$LNG['bd_interrupt']						= 'Cancel';
$LNG['bd_cancel']							= 'Cancel';
$LNG['bd_working']							= 'Busy';
$LNG['bd_build']							= 'Build';
$LNG['bd_build_next_level']					= 'Upgrade ';
$LNG['bd_research']							= 'Research';
$LNG['bd_tech']								= 'Research';
$LNG['bd_tech_next_level']					= 'Research to the next level ';
$LNG['bd_add_to_list']				        = 'Add to list';
$LNG['bd_no_more_fields']					= 'Planet has no fields remaining';
$LNG['bd_remaining']						= 'Remaining:';
$LNG['bd_lab_required']					    = 'First, you have to build a research lab!';
$LNG['bd_building_lab']					    = 'You cannot research during lab upgrades.';
$LNG['bd_max_lvl']                          = 'Max. Level:';
$LNG['bd_lvl']								= 'Level';
$LNG['bd_research']							= 'Research for';
$LNG['bd_shipyard_required']				= 'You need to build a Shipyard first';
$LNG['bd_building_shipyard']				=  'Cannot build ships until Shipyard upgrade is completed.';
$LNG['bd_available']						= 'Available: ';
$LNG['bd_build_ships']						= 'Build';
$LNG['bd_protection_shield_only_one']		= 'You can only build one shield!';
$LNG['bd_build_defenses']					= 'Build defense';
$LNG['bd_actual_production']				= 'Current production:';
$LNG['bd_completed']						= 'Complete';
$LNG['bd_operating']						= '(In construction)';
$LNG['bd_continue']							= 'Continue';
$LNG['bd_price_for_destroy']				= 'Cost to demolish:';
$LNG['bd_ready']							= 'Ready';
$LNG['bd_finished']							= 'Finished';
$LNG['bd_maxlevel']                         = 'Maximum level reached';
$LNG['bd_on']                               = 'connected';
$LNG['bd_max_builds']                       = 'You will have only max. %d queue building!';
$LNG['bd_next_level']                       = 'Next level:';
$LNG['bd_need_engine']                      = 'Requires <font color="#FF0000">%s</font> more %s';
$LNG['bd_more_engine']                      = 'Will produce <font color="#00FF00">%s</font> %s more';
$LNG['bd_jump_gate_action']                 = 'Jump';
$LNG['bd_cancel_warning']                   = 'ATTENTION! <br> If you cancel only will recoup 60% of your cost.';
$LNG['bd_cancel_send']                      = 'Cancel construction';
$LNG['bd_destroy_time'] 					= 'Duration';
$LNG['bd_max_ships']                        = 'max';
$LNG['bd_max_ships_long']					= 'Maximum possible units to build';
$LNG['sys_notenough_money'] 				= 'You dont have enough resources on %s <a href="./game.php?page=buildings&amp;cp=%d&amp;re=0">[%d:%d:%d]</a> to build %s. <br>Your ressources are: %s %s , %s %s and %s %s. <br>The cost of construction is %s %s , %s %s and %s %s.';
$LNG['sys_nomore_level'] 					= "There's no building ( %s ) to demolish.";
$LNG['sys_buildlist'] 						= "List of construction";
$LNG['sys_techlist'] 						= 'Research list';
$LNG['sys_buildlist_fail'] 				    = "Impossible to build";
$LNG['tech_not_satisfied'] = "Technology is not satisfied !";
//----------------------------------------------------------------------------//
// Resources
$LNG['rs_amount']							= 'Quantity';
$LNG['rs_lvl']								= 'Level';
$LNG['rs_production_on_planet']			    = 'Resources produced on the planet "%s"';
$LNG['rs_basic_income']					    = 'Basic Production';
$LNG['rs_storage_capacity']				    = 'Storage capacity';
$LNG['rs_calculate']						= 'Cost estimate';
$LNG['rs_sum']								= 'Total';
$LNG['rs_daily']					        = 'Daily Production:';
$LNG['rs_weekly']							= 'Weekly Production:';
$LNG['rs_ress_bonus']                       = 'Bonus (Officers/Bonus):';

//----------------------------------------------------------------------------//
// Officers
$LNG['of_recruit']							= 'Recruit';
$LNG['of_max_lvl']							= 'Max Level';
$LNG['of_offi']								= 'Official';
$LNG['of_lvl']								= 'Level';
$LNG['of_dm_trade']							= '%s - Shop';
$LNG['of_still']							= 'Continue';
$LNG['of_active']							= 'Active';

//----------------------------------------------------------------------------//
// Merchants

$LNG['tr_cost_dm_trader']					= 'You have to pay the merchant %s %s!';
$LNG['tr_not_enought']						= "Don't have enough %s.";
$LNG['tr_exchange_done']					= 'Trade successful';
$LNG['tr_exchange_error']					= 'The amount of resources is wrong or are insufficient';
$LNG['tr_call_trader']						= 'Call a merchant';
$LNG['tr_call_trader_who_buys']				= 'Call a merchant who purchases';
$LNG['tr_call_trader_submit']				= 'Call Merchant';
$LNG['tr_exchange_quota']					= 'The exchange rate is';
$LNG['tr_sell']								= 'Selling ';
$LNG['tr_resource']							= 'Resource';
$LNG['tr_amount']							= 'Amount';
$LNG['tr_quota_exchange']					= 'Fee';
$LNG['tr_exchange']							= 'Trade';

//----------------------------------------------------------------------------//
// Tecnology
$LNG['tt_requirements']						= 'Requirements';
$LNG['tt_lvl']								= 'Level ';

//----------------------------------------------------------------------------//
// Infos
$LNG['in_jump_gate_no_target']				= 'No target jump available.';
$LNG['in_jump_gate_done']					= 'The jump portal was used, you can use it in:';
$LNG['in_jump_gate_error_data']			    = 'Error, coordinates to jump are not correct!';
$LNG['in_jump_gate_not_ready_target']		= 'The portal is not ready in destination Moon, will be ready in ';
$LNG['in_jump_gate_doesnt_have_one']		= 'Dont you have another portal to make the jump!';
$LNG['in_jump_gate_already_used']			= 'The jump gate was used, time to load energy: ';
$LNG['in_jump_gate_available']				= 'Available';
$LNG['in_rf_again']    			            = 'Rapidfire against';
$LNG['in_rf_from']     			            = 'Rapidfire from';
$LNG['in_level']       				        = 'Level';
$LNG['in_storage'] 							= 'Storage';
$LNG['in_prod_p_hour'] 						= 'Prod. per hour';
$LNG['in_difference']  						= 'Difference';
$LNG['in_range']       						= 'Sensor range';
$LNG['in_title_head']  						= 'Information of';
$LNG['in_name']        						= 'Name';
$LNG['in_struct_pt']   			            = 'Structural integrity';
$LNG['in_shield_pt']   			            = 'Shield Power';
$LNG['in_attack_pt']   			            = 'Attack Power';
$LNG['in_capacity']    				        = 'Cargo capacity';
$LNG['in_units']       			            = 'Unit';
$LNG['in_base_speed'] 				        = 'Base speed';
$LNG['in_consumption'] 	                    = 'Fuel used(Deuterium)';
$LNG['in_jump_gate_start_moon']			    = 'Moon jump';
$LNG['in_jump_gate_finish_moon']			= 'Destination Moon jump';
$LNG['in_jump_gate_select_ships']	        = 'Use the jump portal: number of ships';
$LNG['in_jump_gate_wait_time']              = 'Next jump possible in:';
$LNG['in_jump_gate_jump']					= 'Jump';
$LNG['in_destroy']     						= 'Destroy:';
$LNG['in_needed']      						= 'Requires';
$LNG['in_dest_durati'] 			            = 'Effect duration';
$LNG['in_missilestype']   					= 'Missile type';
$LNG['in_missilesamount']    				= 'Number of Missiles avaliable';
$LNG['in_engine'] 							= 'Engine';
$LNG['in_bonus'] 							= 'Bonus:';

//----------------------------------------------------------------------------//
// Mensagens
$LNG['mg_type'][0]                          = 'Spy messages';
$LNG['mg_type'][1]                          = 'Player messages';
$LNG['mg_type'][2]                          = 'Alliance messages';
$LNG['mg_type'][3]                          = 'Combat messages';
$LNG['mg_type'][4]                          = 'System messages';
$LNG['mg_type'][5]                          = 'Transport messages';
$LNG['mg_type'][15]                         = 'Expedition messages';
$LNG['mg_type'][50]                         = 'Game messages';
$LNG['mg_type'][99]                         = 'Construction messages';
$LNG['mg_type'][100]                        = 'All messages';
$LNG['mg_type'][999]                        = 'Outbox';
$LNG['mg_no_subject']			            = 'No subject';
$LNG['mg_no_text']				            = 'Without text';
$LNG['mg_msg_sended']			            = 'Message sent';
$LNG['mg_delete_marked']		            = 'Delete marked messages';
$LNG['mg_delete_type_all']                  = 'Delete all messages of this type';
$LNG['mg_delete_unmarked']                  = 'Delete all messages not marked';
$LNG['mg_delete_all']		                = 'Delete all messages';
$LNG['mg_show_only_header_spy_reports']	    = 'Show only a part of the espionage reports ';
$LNG['mg_action']							= 'Action';
$LNG['mg_date']					        	= 'Date';
$LNG['mg_from']					            = 'From';
$LNG['mg_to']                               = 'To';
$LNG['mg_subject']					        = 'Subject';
$LNG['mg_message_title']					= 'Messages';
$LNG['mg_message_type']			            = 'Message type';
$LNG['mg_total']				            = 'Total';
$LNG['mg_game_operators']			        = 'Game operators';
$LNG['mg_error']                            = 'Recipient is not found!';
$LNG['mg_overview']                         = 'News of administration';
$LNG['mg_send_new']                         = 'Write a message';
$LNG['mg_send_to']                          = 'Receptors';
$LNG['mg_message']                          = 'Message';
$LNG['mg_characters']                       = 'Characters';
$LNG['mg_send']                             = 'Send';
$LNG['mg_game_message']                     = 'Play message';
$LNG['mg_message_send']			            = 'Message Sent!';
$LNG['mg_empty_text']				        = 'Enter Text';
$LNG['mg_answer_to']						= 'Reply to:';
$LNG['mg_write_mail_to_ops']                = 'Write an email to';
$LNG['mg_page']								= 'Page';
$LNG['mg_read_marked']						= 'Mark selected messages as read';
$LNG['mg_read_type_all']					= 'Mark all messages of this type as read';
$LNG['mg_read_all']							= 'Mark all messages as read';
$LNG['mg_confirm']							= 'Confirm';
$LNG['mg_receiver_block_pm']				= 'The receiver block private messages.';
$LNG['mg_deleted']					= 'The message has been deleted.';

//----------------------------------------------------------------------------//
// Aliança

$LNG['al_not_exists']					= 'The Alliance ceased to exist';
$LNG['al_newname_specialchar']				= 'The alliance and the tag must be write with alphanumeric characters, word, _, -, .!';
$LNG['al_description_message']		        = 'Message from description of Alliance';
$LNG['al_web_text']							= 'Alliance Web site';
$LNG['al_request']					        = 'Aplication';
$LNG['al_click_to_send_request']		    = 'Click here to send a message to the Alliance';
$LNG['al_tag_required']					    = 'Missing the tag of the Alliance';
$LNG['al_name_required']					= 'Missing the name of the Alliance';
$LNG['al_already_exists']					= 'The Alliance %s already exists.';
$LNG['al_created']					        = 'The Alliance %s was created';
$LNG['al_continue']							= 'Continue';
$LNG['al_alliance_closed']			        = 'This Alliance does not support more members';
$LNG['al_request_confirmation_message']     = 'Registered application. You will receive a message when youre accepted or/rejected. <br><a href="game.php?page=alliance">back</a>';
$LNG['al_default_request_text']		        = 'The leader of the Alliance didnt wrote any message of introduction.';
$LNG['al_write_request']					= 'Writes the application to the Alliance %s';
$LNG['al_request_deleted']			        = 'Your request for the Alliance %s was deleted. <br> Now you can make a new application or create your own Alliance.';
$LNG['al_request_wait_message']             = 'You have sent a request to the Alliance %s. <br> Please wait for a reply or delete the application.';
$LNG['al_delete_request']					= 'Delete the application';
$LNG['al_founder_cant_leave_alliance']		= "The founder can't leave the Alliance.";
$LNG['al_leave_sucess']						= 'You have left the Alliance %s .';
$LNG['al_do_you_really_want_to_go_out']	    = 'Do you want to leave the Alliance %s?';
$LNG['al_go_out_yes']						= 'Yes';
$LNG['al_go_out_no']                        = 'No';
$LNG['al_close_ally']                       = 'Do you want to close the Alliance ?';
$LNG['al_kick_player']                      = 'Do you want to remove the user %s from Alliance?';
$LNG['al_circular_sended']					= 'Circular message sent. These players will receive your circular message:';
$LNG['al_all_players']						= 'All players';
$LNG['al_no_ranks_defined']				    = 'Without defined positions';
$LNG['al_request_text']						= 'Text of the application';
$LNG['al_inside_text']						= 'Inner text';
$LNG['al_outside_text']						= 'External text';
$LNG['al_transfer_alliance']				= 'Transfer Alliance';
$LNG['al_disolve_alliance']				    = 'Dissolving Alliance';
$LNG['al_founder_rank_text']				= 'Founder';
$LNG['al_new_member_rank_text']			    = 'New Member';
$LNG['al_acept_request']					= 'Accepted';
$LNG['al_you_was_acceted']					= 'You have been accepted into ';
$LNG['al_hi_the_alliance']					= 'Hello !<br>The Alliance <b>';
$LNG['al_has_accepted']						= '</b> Your application has been accepted<br>Message: <br>';
$LNG['al_decline_request']					= 'Rejected';
$LNG['al_you_was_declined']				    = 'You were rejected in ';
$LNG['al_has_declined']						= '</b> The Alliance has rejected your application <br>Message: <br>';
$LNG['al_no_requests']						= 'No requests';
$LNG['al_request_from']						= 'Request for "%s"';
$LNG['al_no_request_pending']				= 'Have %n aplicações pendentes';
$LNG['al_name']								= 'Change name of Alliance';
$LNG['al_new_name']							= 'Name change (3-30 characters)';
$LNG['al_tag']								= 'Change Tag of Alliance';
$LNG['al_new_tag']							= 'Change Tag (3-8 characters)';
$LNG['al_user_list']						= 'List of members';
$LNG['al_users_list']                       = 'List of members (user: %d)';
$LNG['al_manage_alliance']					= 'Managing Alliance';
$LNG['al_send_circular_message']			= 'Send Circular Message';
$LNG['al_circular_front_text']				= 'The player %s wrote the following:';
$LNG['al_new_requests']						= '%d New orders';
$LNG['al_goto_chat']						= 'Chat of Alliance';
$LNG['al_save']								= 'Save';
$LNG['al_dlte']								= 'Delete';
$LNG['al_rank_name']						= 'Name in rank';
$LNG['al_ok']								= 'OK';
$LNG['al_num']								= 'ID';
$LNG['al_member']							= 'Name';
$LNG['al_request_from_user']                = 'The requests of players';
$LNG['al_request_register_time']            = 'Registered at';
$LNG['al_request_last_onlinetime']          = 'Last activity';
$LNG['al_message']							= 'Message';
$LNG['al_position']							= 'Position';
$LNG['al_points']							= 'Points';
$LNG['al_coords']							= 'Coordinates';
$LNG['al_member_since']						= 'Entered';
$LNG['al_estate']							= 'Online';
$LNG['al_back']								= 'Back';
$LNG['al_actions']							= 'Actions';
$LNG['al_change_title']						= 'Change title';
$LNG['al_the_alliance']						= 'of Alliance';
$LNG['al_change_submit']					= 'Change';
$LNG['al_reply_to_request']				    = 'Responds to the request';
$LNG['al_reason']							= 'Reason';
$LNG['al_characters']						= 'characters';
$LNG['al_request_list']						= 'Request list';
$LNG['al_candidate']						= 'Candidate';
$LNG['al_request_date']						= 'Date of application';
$LNG['al_transfer_alliance']				= 'Abdicate /accept Alliance?';
$LNG['al_transfer_to']						= 'Transfer to';
$LNG['al_transfer_submit']					= 'Transfer';
$LNG['al_ally_information']				    = 'Information of the Alliance';
$LNG['al_ally_info_tag']					= 'Tag';
$LNG['al_ally_info_name']					= 'Name';
$LNG['al_ally_info_members']				= 'Members';
$LNG['al_your_request_title']				= 'Your application';
$LNG['al_applyform_send']					= 'Send';
$LNG['al_applyform_reload']					= 'Reload';
$LNG['al_apply_not_exists']					= 'The application does not exist.';
$LNG['al_circular_send_ciruclar']			= 'Send circular message';
$LNG['al_circular_alliance']				= 'Alliance ';
$LNG['al_receiver']							= 'Receiver';
$LNG['al_circular_send_submit']			    = 'Send';
$LNG['al_circular_reset']					= 'Clean';
$LNG['al_alliance']							= 'Alliance';
$LNG['al_alliance_make']					= 'Create your own Alliance';
$LNG['al_alliance_search']					= 'Search Alliances';
$LNG['al_your_ally']						= 'Your Alliance';
$LNG['al_rank']								= 'Your Rank';
$LNG['al_web_site']							= 'Homepage';
$LNG['al_inside_section']					= 'Internal area';
$LNG['al_make_alliance']					= 'Create Alliance';
$LNG['al_make_ally_tag_required']			= 'Tag of the Alliance (3-8 characters)';
$LNG['al_make_ally_name_required']			= 'Name of the Alliance (3-30 characters)';
$LNG['al_make_submit']						= 'Search';
$LNG['al_find_alliances']					= 'Find Alliances';
$LNG['al_find_text']						= 'Search for';
$LNG['al_find_no_alliances']                = 'No Alliance found!';
$LNG['al_find_submit']						= 'Search';
$LNG['al_manage_ranks']						= 'Configure rights';
$LNG['al_manage_members']					= 'Manage members';
$LNG['al_manage_change_tag']				= 'Change Tag of Alliance';
$LNG['al_manage_change_name']				= 'Change name of Alliance';
$LNG['al_set_max_members']					= 'Maximum number of members';
$LNG['al_manage_request_min_points']        = 'Minimum Points';
$LNG['al_texts']							= 'Options of text';
$LNG['al_manage_options']					= 'Options';
$LNG['al_manage_image']						= 'Image of Alliance';
$LNG['al_manage_requests']					= 'Applications';
$LNG['al_manage_diplo']                    	= 'Diplomacy of Alliance';
$LNG['al_requests_not_allowed']			    = 'Impossible (Alliance closed)';
$LNG['al_requests_allowed']				    = 'Possible (Alliance open)';
$LNG['al_requests_min_points']              = ' %s points';
$LNG['al_manage_founder_rank']				= 'Position of the founder';
$LNG['al_configura_ranks']					= 'Setting rights';
$LNG['al_create_new_rank']					= 'Create new rank';
$LNG['al_create']							= 'Create';
$LNG['al_legend']							= 'Description of ranks';
$LNG['al_legend_disolve_alliance']			= 'Dissolving Alliance';
$LNG['al_legend_kick_users']				= 'Kick members';
$LNG['al_legend_see_requests']				= 'Show applications';
$LNG['al_legend_see_users_list']		    = 'Show list of members';
$LNG['al_legend_check_requests']		    = 'Process application';
$LNG['al_legend_admin_alliance']			= 'Managing Alliance';
$LNG['al_legend_see_connected_users']		= 'See players online in the members list';
$LNG['al_legend_create_circular']		    = 'Writes circular message';
$LNG['al_legend_right_hand']			    = '"Right hand" (required to pass as founder)';
$LNG['al_requests']							= 'Requests';
$LNG['al_circular_message']			        = 'Global message';
$LNG['al_leave_alliance']					= 'Leave this Alliance';
$LNG['al_unitsshut']    					= 'Units destroyed';
$LNG['al_unitsloos']    					= 'Units lost';
$LNG['al_tfmetall']     					= 'Debris of Metal';
$LNG['al_tfkristall']   					= 'Debris of Crystal';
$LNG['al_view_stats']						= 'Statistics of battle public?';
$LNG['al_view_diplo']						= 'Diplomacy is public?';
$LNG['al_view_events']						= 'Viewing events';
$LNG['al_memberlist_min']					= 'min';
$LNG['al_memberlist_on']					= 'Online';
$LNG['al_memberlist_off']					= 'Offline';
$LNG['al_diplo']							= 'Diplomacy';
$LNG['al_no_diplo']							= '-';
$LNG['al_events']							= 'Events';
$LNG['al_no_events']						= 'There are currently no events';
$LNG['al_diplo_level'][1]                   = 'Wing';
$LNG['al_diplo_level'][2]                   = 'Alliance';
$LNG['al_diplo_level'][3]                   = 'Trade Pact';
$LNG['al_diplo_level'][4]                   = 'Non-agression Pact';
$LNG['al_diplo_level'][5]                   = 'War';
$LNG['al_diplo_level'][6]					= 'Secret Alliance';
$LNG['al_diplo_no_entry']                   = '- There is no Pact -';
$LNG['al_diplo_no_accept']                  = '- Without applications available -';
$LNG['al_diplo_accept']                     = 'Applications';
$LNG['al_diplo_exists']						= 'There is already a valid or not yet accepted diplomatic relationship with the Alliance "%s"!';
$LNG['al_diplo_accept_send']                = 'Output requests';
$LNG['al_diplo_create']                     = 'Create new Pact.';
$LNG['al_diplo_create_done']                = 'The Pact created successfully.';
$LNG['al_diplo_ally']                       = 'Alliance';
$LNG['al_diplo_level_des']                  = 'Kind of Pacts';
$LNG['al_diplo_text']                       = 'Text/Request';
$LNG['al_diplo_accept_yes']                 = 'Pact signed.';
$LNG['al_diplo_accept_yes_mes']             = 'The Pact (%s) between the %s and %s was Signed!';
$LNG['al_diplo_accept_yes_confirm']		    = 'Want to really accept the Pact?';
$LNG['al_diplo_accept_no']                  = 'Pact Rejected.';
$LNG['al_diplo_accept_no_mes']				= 'The Pact (%s) between the %s and %s was Rejected!';
$LNG['al_diplo_accept_no_confirm']			= 'Want to really reject the Pact?';
$LNG['al_diplo_delete']                     = 'Deleted Pact.';
$LNG['al_diplo_delete_mes']                 = 'The Pact (%s) between the %s and %s was deleted!';
$LNG['al_diplo_confirm_delete']             = 'Did you want to delete the Pact?';
$LNG['al_diplo_ground']                     = 'Reasons:';
$LNG['al_diplo_ask']                        = 'Survey Pact';
$LNG['al_diplo_ask_mes']                    = 'The (%s) between the alliances %s and %s.<br>Reasons: %s';
$LNG['al_diplo_war']                        = 'Declaration of war';
$LNG['al_diplo_war_mes']                    = 'The Alliance %s and the Alliance %s just the %s declarated.<br>Reason:<br>%s<br><br>Information: the war is valid for 24 hours. Only after the 24 hours, war and given as terminated. <br>More information consult the <a href="index.php?page=rules" target="_blank">Rules</a>.';
$LNG['al_diplo_head']						= 'Management of Diplomacy';
$LNG['al_diplo_same_alliance']				= 'You can not make a pact with your own Alliance!';
$LNG['al_diplo_no_alliance']				= 'There is no alliance with the name of %s!';
$LNG['al_diplo_info']						= '<p>Here is displayed different kinds of Alliance and can see your Covenants [TODO: FAQ]</p>';
$LNG['al_leave_ally']						= 'Are you sure to leave the Alliance?';
$LNG['al_default_leader_name']				= 'Leader';
$LNG['al_rank_name']						= 'Name';
$LNG['al_rank_desc']['MEMBERLIST']			= 'Can see the members';
$LNG['al_rank_desc']['ONLINESTATE']			= 'Can see who is online';
$LNG['al_rank_desc']['TRANSFER']			= 'Can be a leader';
$LNG['al_rank_desc']['SEEAPPLY']			= 'Can view the applications';
$LNG['al_rank_desc']['MANAGEAPPLY']			= 'Can control applications';
$LNG['al_rank_desc']['ROUNDMAIL']			= 'Can send global message';
$LNG['al_rank_desc']['ADMIN']				= 'Can edit the Alliance';
$LNG['al_rank_desc']['KICK']				= 'Can deleting members';
$LNG['al_rank_desc']['DIPLOMATIC']			= 'Can manage the Diplomacy';
$LNG['al_rank_desc']['RANKS']				= 'Can configure the Ranks';
$LNG['al_rank_desc']['MANAGEUSERS']			= 'Can manage members';
$LNG['al_rank_desc']['EVENTS']			= 'Can see events';
$LNG['al_invalid_rank_name']				= 'In the Rank name only numbers, letters, spaces, _, -. allowed!';
$LNG['al_make_ally_insufficient_points']	= 'You do have not enough points to create an Alliance.<br>It requires %s points, and you have %s points.';
$LNG['al_new_apply']                      	= 'Your alliance has received a new application from - <a href="#" onclick="return Dialog.Playercard(%s, \'%s\');">%s</a>';

//----------------------------------------------------------------------------//
// Lista de Amigos
$LNG['bu_request_exists']					= 'There is already an application for this player!';
$LNG['bu_cannot_request_yourself']			= 'You can not send a friend request to you';
$LNG['bu_request_message']					= 'Message request';
$LNG['bu_player']							= 'Player';
$LNG['bu_request_text']						= 'Text of the application';
$LNG['bu_characters']						= 'Characters';
$LNG['bu_back']								= 'Back';
$LNG['bu_send']								= 'Send';
$LNG['bu_cancel_request']					= 'Cancel request';
$LNG['bu_accept']							= 'Accepted';
$LNG['bu_decline']							= 'Denied';
$LNG['bu_connected']						= 'Connected';
$LNG['bu_minutes']                          = ' min';
$LNG['bu_online']                           = 'Online';
$LNG['bu_disconnected']						= 'Offline';
$LNG['bu_buddy_list']						= 'Friends list';
$LNG['bu_requests']							= 'Applications';
$LNG['bu_alliance']							= 'Alliance';
$LNG['bu_coords']							= 'Coordinates';
$LNG['bu_text']								= 'Text';
$LNG['bu_action']							= 'Action';
$LNG['bu_my_requests']						= 'My requests';
$LNG['bu_partners']							= 'Partners';
$LNG['bu_delete']                           = 'Delete';
$LNG['bu_no_request']                       = 'No application available!';
$LNG['bu_no_buddys']                        = 'No friends available!';
$LNG['bu_request_send']                     = 'Request sent!';
$LNG['bu_new_request_title']				= 'New friend request!';
$LNG['bu_new_request_body']					= 'Hello %s,<br>%s sent a friend request!';
$LNG['bu_accepted_request_title']			= 'Accept friend request!';
$LNG['bu_accepted_request_body']			= 'Hello %s,<br>%s accepted your friend request!';
$LNG['bu_rejected_request_title']			= 'Friend request Refused!';
$LNG['bu_rejected_request_body']			= 'Hello %s,<br>%s refused your request for friendship!';

//----------------------------------------------------------------------------//
// Notas
$LNG['nt_important']						= 'Important';
$LNG['nt_normal']							= 'Normal';
$LNG['nt_unimportant']						= 'Unimportant';
$LNG['nt_create_note']						= 'Create note';
$LNG['nt_you_dont_have_notes']				= 'No notes available';
$LNG['nt_notes']							= 'Notes';
$LNG['nt_create_new_note']					= 'Create a new note';
$LNG['nt_edit_note']						= 'Edit Note';
$LNG['nt_date_note']						= 'Date';
$LNG['nt_subject_note']						= 'Subject';
$LNG['nt_size_note']						= 'Size';
$LNG['nt_dlte_note']						= 'Delete';
$LNG['nt_priority']							= 'Priority';
$LNG['nt_note']								= 'Notice';
$LNG['nt_characters']						= 'characters';
$LNG['nt_back']								= 'Back';
$LNG['nt_reset']							= 'Reset';
$LNG['nt_save']								= 'Save';
$LNG['nt_no_title']							= 'No title';
$LNG['nt_no_text']							= 'No Text';
$LNG['nt_error_add_1'] = "You cannot have more than %s notes";
//----------------------------------------------------------------------------//
// Estatísticas
$LNG['st_player']							= 'Player';
$LNG['st_alliance']							= 'Alliance';
$LNG['st_points']							= 'Points';
$LNG['st_fleets']							= 'Fleet';
$LNG['st_researh']							= 'Research';
$LNG['st_buildings']						= 'Building';
$LNG['st_defenses']							= 'Defense';
$LNG['st_position']							= 'Rank';
$LNG['st_members']							= 'Member';
$LNG['st_per_member']						= 'Per Member';
$LNG['st_statistics']						= 'Statistics';
$LNG['st_updated']							= 'Updated';
$LNG['st_show']								= 'show';
$LNG['st_per']								= 'by';
$LNG['st_in_the_positions']					= 'in ranks';
$LNG['st_write_message']					= 'Private Message';

//----------------------------------------------------------------------------//
// Procurar
$LNG['sh_tag']							= 'Tag';
$LNG['sh_name']							= 'Name';
$LNG['sh_members']							= 'Member';
$LNG['sh_points']							= 'Points';
$LNG['sh_search_in_the_universe']			= 'Search Universe';
$LNG['sh_player_name']						= 'Player Name';
$LNG['sh_planet_name']						= 'Planet Name';
$LNG['sh_alliance_tag']						= 'Alliance Tag';
$LNG['sh_alliance_name']					= 'Alliance Name';
$LNG['sh_search']							= 'search';
$LNG['sh_write_message']					= 'Private Message';
$LNG['sh_buddy_request']					= 'Buddy request';
$LNG['sh_alliance']							= 'Alliance';
$LNG['sh_planet']							= 'Planet';
$LNG['sh_coords']							= 'Position';
$LNG['sh_position']							= 'Rank';
$LNG['sh_loading']							= '(Loading ...)';

//----------------------------------------------------------------------------//
//OPTIONS
$LNG['op_error']							= 'Error';
$LNG['op_cant_activate_vacation_mode']		= 'You can not activate the vacation mode with fleet actiividades.';
$LNG['op_password_changed']					= 'Password changed';
$LNG['op_username_changed']					= 'Username changed';
$LNG['op_options_changed']					= 'Options changed';
$LNG['op_vacation_mode_active_message']		= 'Vacation mode is active and will end up in: ';
$LNG['op_end_vacation_mode']				= 'End period of vacation';
$LNG['op_save_changes']						= 'Save changes';
$LNG['op_admin_title_options']				= 'Administrative Options';
$LNG['op_admin_planets_protection']			= 'Enable protection of Planets';
$LNG['op_user_data']						= 'User data';
$LNG['op_username']							= 'Name';
$LNG['op_old_pass']							= 'Current Password';
$LNG['op_new_pass']							= 'New Password (min. 8 characters)';
$LNG['op_repeat_new_pass']					= 'New Password (repeat)';
$LNG['op_email_adress']						= 'Email address';
$LNG['op_permanent_email_adress']			= 'Permanent email address';
$LNG['op_general_settings']					= 'General options';
$LNG['op_sort_planets_by']					= 'Sort by planets';
$LNG['op_sort_kind']						= 'Order of classification';
$LNG['op_lang']								= 'Language';
$LNG['op_skin_example']						= 'Theme';
$LNG['op_show_skin']						= 'Display Skin';
$LNG['op_deactivate_ipcheck']				= 'Verification of IP disabled';
$LNG['op_galaxy_settings']					= 'Options of Galaxy';
$LNG['op_spy_probes_number']				= 'Number of Spy probes';
$LNG['op_toolt_data']						= 'Show tips for';
$LNG['op_seconds']							= 'Seconds';
$LNG['op_max_fleets_messages']				= 'Number of max messages of Fleet';
$LNG['op_show_planetmenu']					= 'View menu of Planets';
$LNG['op_shortcut']							= 'Shortcut';
$LNG['op_show']								= 'View';
$LNG['op_spy']								= 'Spying';
$LNG['op_write_message']					= 'Write Message';
$LNG['op_add_to_buddy_list']				= 'Send friend request';
$LNG['op_missile_attack']					= 'Missile attack';
$LNG['op_send_report']						= 'Send report';
$LNG['op_vacation_delete_mode']				= 'Vacation mode/delete account';
$LNG['op_activate_vacation_mode']			= 'Activate vacation mode';
$LNG['op_dlte_account']						= 'Delete account';
$LNG['op_email_adress_descrip']				= 'You can change this e-mail address at any time. Will become the permanent e-mail after 7 days, without changes.';
$LNG['op_deactivate_ipcheck_descrip']		= 'Verification of IP means that the security logout occurs automatically when the IP changes or two people are recorded in an account of different IPs. Disabling the check of IP can represent a security risk!';
$LNG['op_spy_probes_number_descrip']		= 'Number of probes you can send directly from the view of Galaxia.';
$LNG['op_activate_vacation_mode_descrip']	= 'Vacation mode protects your account for as long as you are out of the game. But you can only activate it if its not you have nothing in construction (buildings, fleet, or defense), and nothing to be searched, and none of your fleets is destroyed. Once activated, is protected against attacks. Attacks that had already been posted before will continue during the holidays, the production is put at 0% so desativares vacation mode will reset the production to 100%. So ativares the holidays are bound to remain so for a minimum time of 48 hours. Only then will be disabled.';
$LNG['op_dlte_account_descrip']			    = 'If you choose this option your account will be deleted after 7 days.';
$LNG['op_need_pass_mail']                   = 'To change your email address is need to enter the password in the box!';
$LNG['op_not_vaild_mail']					= 'You dont inserted a valid E-Mail!';
$LNG['op_change_mail_exist']				= 'The Email introduced %s already in use!';
$LNG['op_sort_normal']                      = 'By the Colonization';
$LNG['op_sort_koords']                      = 'By Coordinates';
$LNG['op_sort_abc']                         = 'By Alphabet';
$LNG['op_sort_up']                          = 'Ascendant';
$LNG['op_sort_down']                        = 'Descendant';
$LNG['op_user_name_no_alphanumeric']        = 'Please enter the user name only alphanumeric characters!';
$LNG['op_change_name_pro_week']             = 'Only you can change your username once every 7 days!';
$LNG['op_change_name_exist']                = 'The name chosen %s already exists';
$LNG['op_active_build_messages']            = 'Enable messages of building';
$LNG['op_active_spy_messages_mode']			= 'Enable Summarized Spy Reports';
$LNG['op_dst_mode']							= 'Daylight Saving Time?';
$LNG['op_dst_mode_sel'][0]					= 'Yes';
$LNG['op_dst_mode_sel'][1]					= 'No';
$LNG['op_dst_mode_sel'][2]					= 'Automatic';
$LNG['op_timezone']							= 'Time zone';
$LNG['op_block_pm']							= 'Block private messages';

//----------------------------------------------------------------------------//
// Lista de Jogadores Banidos
$LNG['bn_no_players_banned']				= 'No banned players';
$LNG['bn_exists']							= 'Total ';
$LNG['bn_players_banned']					= ' player`s banned';
$LNG['bn_players_banned_list']				= 'List of banned players';
$LNG['bn_player']							= 'Player';
$LNG['bn_reason']							= 'Reason';
$LNG['bn_from']								= 'From';
$LNG['bn_until']							= 'Until';
$LNG['bn_by']								= 'By';
$LNG['bn_writemail']						= 'Mail to %s';

//----------------------------------------------------------------------------//
// Sessões do Jogo

// Manutenção & Banido
$LNG['css_account_banned_message']          = 'Your account has been banned!';
$LNG['css_account_banned_expire']           = 'Your account is already unbanned %s!';
$LNG['css_goto_homeside']                   = '<a href="./index.php">Go to the homepage</a>';
$LNG['css_server_maintrace']                = 'Maintenance of the server<br><br>The game is closed.<br><br>Até: %s';

//----------------------------------------------------------------------------//
// Actividades de Frota

$LNG['cff_aproaching']						= 'The fleet is composed of ';
$LNG['cff_ships']							= ' units';
$LNG['cff_no_fleet_data']					= 'Without fleet data';
$LNG['cff_fleet_own']						= 'Fleet';
$LNG['cff_fleet_target']					= 'Fleets';
$LNG['cff_acs_fleet']						= 'Fleet in ACS';
$LNG['cff_mission_acs']						= 'A %s from %s %s %s reached the %s %s %s. Mission: %s';
$LNG['cff_mission_own_0']					= 'One of your %s from %s %s %s reached the %s %s %s. Mission: %s';
$LNG['cff_mission_own_1']					= 'One of your %s returns from %s %s %s back to %s %s %s. Mission: %s';
$LNG['cff_mission_own_2']					= 'One of your %s from %s %s %s are in orbit around %s %s %s. Mission: %s';
$LNG['cff_mission_own_mip']					= 'Missile attack (%d) from %s %s %s to %s %s %s.';
$LNG['cff_mission_own_expo_0']				= 'One of your %s from %s %s %s reached the Position %s. Mission: %s';
$LNG['cff_mission_own_expo_1']				= 'One of your %s returns from the Position %s back to %s %s %s. Mission: %s';
$LNG['cff_mission_own_expo_2']				= 'One of your %s from %s %s %s is on a Expedition to Position %s. Mission: %s';
$LNG['cff_mission_own_recy_0']				= 'One of your %s from %s %s %s reached the debris %s. Mission: %s';
$LNG['cff_mission_own_recy_1']				= 'One of your %s returns from debris %s back to planet %s %s %s. Mission: %s';
$LNG['cff_mission_target_bad']				= 'A hostile %s from player %s from %s %s %s reached the %s %s %s. Mission: %s';
$LNG['cff_mission_target_good']				= 'A friendly %s from player %s from %s %s %s reached the %s %s %s. Mission: %s';
$LNG['cff_mission_target_stay']				= 'A friendly %s from player %s from %s %s %s is in Orbit of the %s %s %s. Mission: %s';
$LNG['cff_mission_target_mip']				= 'Missile attack (%d) from player %s from %s %s %s on the %s %s %s.';

//----------------------------------------------------------------------------//
// Funções Extras
$LNG['fcm_universe']						= 'Universe';
$LNG['fcm_mainplanet']						= 'Main Planet';
$LNG['fcm_planet']							= 'Planet';
$LNG['fcm_moon']							= 'Moon';
$LNG['fcm_info']							= 'Info';
$LNG['fcp_colony']							= 'Colony';
$LNG['fgp_require']							= 'Requirements: ';
$LNG['fgf_time']							= 'Time: ';
$LNG['sys_module_inactive']        	 		= 'Inactive module';
$LNG['sys_refferal_from']        	 		= 'System';
$LNG['sys_refferal_title']        	 		= 'Player Bonus %s';
$LNG['sys_refferal_text']        	 		= 'The player %s recruited by you reached %s points.<br><br>You invite a player active, will be rewarded %s %s';
$LNG['sys_closed_game']        	 			= 'The game is currently not available:';
$LNG['spec_mail_inactive_title']  			= '%s - Reminder';
$LNG['sys_back']							= 'Back';
$LNG['sys_forward']							= 'Next';


$LNG['market_p_total']  ='Total';
$LNG['market_p_ratio']  ='Ratio';
$LNG['market_p_cost_type']   ='Cost type';
$LNG['market_p_cost_amount']  ='Amount';
$LNG['market_p_end']  = 'End';
$LNG['market_p_from_duration']  ='Flight from';
$LNG['market_p_to_duration']  ='Flight to';
$LNG['market_p_submit']  = 'Buy now!';
$LNG['market_p_buy']  = 'Buy';
$LNG['market_ship_as_first'] = 'Ship type as first';
$LNG['market_confirm_are_you_sure'] = 'Are you sure?';
$LNG['market_info_header'] = "Marketplace";
$LNG['market_info_description'] = "Left side - sale offers | Right side - buy amount<br><br>&bull; Bought offers cannot be canceled &bull;<br>&bull; Players are allowed to trade for any exchange rate (ratio) &bull;";
$LNG['market_fleet']  = 'Fleet';

$LNG['market_p_msg_not_found']  = 'Offer not found.';
$LNG['market_p_msg_more_ships_is_needed']  = 'More ships required.';
$LNG['market_p_msg_resources_error']  = 'Not enough resources.';
$LNG['market_p_msg_sent']  = 'Sent %s Light Cargos, %s Heavy Cargos';

$LNG['market_msg_trade_topic'] = "Trading status";
$LNG['market_msg_trade_from'] = "Trading zone";
$LNG['market_msg_trade_bought'] 					= 'Your fleet is flying to %s with %s %s, %s %s, %s %s and it costs %s %s';
$LNG['market_msg_trade_sold'] 					= 'Your fleet is flying to %s with %s %s, %s %s, %s %s.';

$LNG['market_buyable_only_trade_partners'] 					= 'Only partners';
$LNG['market_buyable_no_enemies'] 					= 'No enemies';
$LNG['market_buyable_no_tech'] 					= 'Too weak';
//----------------------------------------------------------------------------//
// Relatório de Combate
$LNG['cr_lost_contact']                     = 'Lost touch with your fleet.';
$LNG['cr_first_round']                      = '(The fleet was destroyed in the first round)';
$LNG['cr_type']								= 'Type';
$LNG['cr_total']							= 'Total';
$LNG['cr_weapons']							= 'Weapons';
$LNG['cr_shields']							= 'Shield';
$LNG['cr_armor']							= 'Armor';
$LNG['cr_destroyed']						= 'Destroyed!';

//----------------------------------------------------------------------------//
// Erro de Frotas
$LNG['fa_not_enough_probes']				= 'Sorry, no probes available';
$LNG['fa_galaxy_not_exist']					= 'Fault, galaxy does not exist';
$LNG['fa_system_not_exist']					= 'Fault, system does not exist';
$LNG['fa_planet_not_exist']					= 'Fault, planet does not exist';
$LNG['fa_not_enough_fuel']					= 'Fault, not enough fuel';
$LNG['fa_no_more_slots']					= 'Fault, not enough fleet Slots';
$LNG['fa_no_recyclers']						= 'Sorry, no Recycler available';
$LNG['fa_no_fleetroom']						= 'Fault, not enough cargo for fuel';
$LNG['fa_mission_not_available']			= 'Fault, mission not available';
$LNG['fa_no_spios']							= 'Fault, no probes available';
$LNG['fa_vacation_mode']					= 'Player is in vacation mode';
$LNG['fa_week_player']						= 'Player is too weak';
$LNG['fa_strong_player']					= 'Player is too strong';
$LNG['fa_not_spy_yourself']					= 'Fault, can not spy on yourself!';
$LNG['fa_not_attack_yourself']				= 'Fault, can not attack yourself';
$LNG['fa_action_not_allowed']				= 'Fault, action not allowed';
$LNG['fa_vacation_mode_current']			= 'Fault, you are in vaction mode';
$LNG['fa_sending']							= 'Send';

//----------------------------------------------------------------------------//
// Misseis
$LNG['ma_silo_level']						= 'Silo Level 4 Required! ';
$LNG['ma_impulse_drive_required']			= 'Impulse drive required';
$LNG['ma_not_send_other_galaxy']			= 'You cannot send rockets into another galaxy. ';
$LNG['ma_planet_doesnt_exists']				= 'Planet does not exist. ';
$LNG['ma_wrong_target']						= 'Wrong Target';
$LNG['ma_no_missiles']						= 'No Missles';
$LNG['ma_add_missile_number']				= 'Add missile amount! ';
$LNG['ma_misil_launcher']					= 'Rocket Launcher';
$LNG['ma_small_laser']						= 'Light Laser Gun';
$LNG['ma_big_laser']						= 'Heavy Laser Gun';
$LNG['ma_gauss_canyon']						= 'Gauss Cannon';
$LNG['ma_ionic_canyon']						= 'Ion cannon';
$LNG['ma_buster_canyon']					= 'Plasma Cannon';
$LNG['ma_small_protection_shield']			= 'Small Shield Dome';
$LNG['ma_big_protection_shield']			= 'Large Shield Dome';
$LNG['ma_all']								= 'All';
$LNG['ma_missiles_sended']					= ' Missles Deployed. Targeted: ';

//----------------------------------------------------------------------------//
// Hall da Fama
$LNG['tkb_top']								= 'Hall of Fame';
$LNG['tkb_gratz']							= 'The whole team congratulates the top 100 ';
$LNG['tkb_platz']							= 'Place';
$LNG['tkb_owners']							= 'Users involved';
$LNG['tkb_datum']							= 'Date';
$LNG['tkb_units']							= 'Units';
$LNG['tkb_legende']							= '<b>Legend: </b>';
$LNG['tkb_gewinner']						= '<b>-Winner-</b>';
$LNG['tkb_verlierer']						= '<b>-Loser-</b>';
$LNG['tkb_unentschieden']					= '<b>-Both Weisses, undecided- </b>';
$LNG['tkb_missing']							= '<br>Missing in Action: The user account does not exist any more.';

//----------------------------------------------------------------------------//
// Perfil de Jogador
$LNG['pl_overview']							= 'Player Profile';
$LNG['pl_name']								= 'Username';
$LNG['pl_homeplanet']						= 'Home planet';
$LNG['pl_ally']								= 'Alliance';
$LNG['pl_message']							= 'Message';
$LNG['pl_buddy']							= 'Buddy';
$LNG['pl_points']							= 'Points';
$LNG['pl_range']							= 'Rank';
$LNG['pl_builds']							= 'Buildings';
$LNG['pl_tech']								= 'Research';
$LNG['pl_fleet']							= 'Fleet';
$LNG['pl_def']								= 'Defense';
$LNG['pl_total']							= 'Total';
$LNG['pl_fightstats']						= 'Fight Stats';
$LNG['pl_fights']							= 'Fights';
$LNG['pl_fprocent']							= 'Fight quota ';
$LNG['pl_fightwon']							= 'Won';
$LNG['pl_fightdraw']						= 'Drawn';
$LNG['pl_fightlose']						= 'Lost';
$LNG['pl_totalfight']						= 'Total fights';
$LNG['pl_destroy']							= '%s Destroy';
$LNG['pl_unitsshot']						= 'Units Killed';
$LNG['pl_unitslose']						= 'Units Lost';
$LNG['pl_dermetal']							= 'Recycled Metal';
$LNG['pl_dercrystal']						= 'Recycled Crystal';
$LNG['pl_etc']								= 'Etc ';

//----------------------------------------------------------------------------//
// Suporte

$LNG['ti_header'] 							= 'Support system';
$LNG['ti_overview'] 						= 'Back';
$LNG['ti_id'] 								= 'Ticket';
$LNG['ti_username'] 						= 'Player';
$LNG['ti_subject'] 							= 'Subject';
$LNG['ti_status'] 							= 'State';
$LNG['ti_date'] 							= 'Data';
$LNG['ti_answers'] 							= 'Reply';
$LNG['ti_close'] 							= 'Ticket closed';
$LNG['ti_open'] 							= 'Open Ticket';
$LNG['ti_new'] 								= 'New ticket';
$LNG['ti_status_open'] 						= 'Open';
$LNG['ti_status_closed'] 					= 'Closed';
$LNG['ti_status_answer'] 					= 'Response';
$LNG['ti_admin_open'] 						= 'The ticket has been opened!';
$LNG['ti_admin_close'] 						= 'The ticket was closed!';
$LNG['ti_error_closed'] 					= 'No answer can be created on this ticket, because it was already closed!';
$LNG['ti_create_info']						= '<p>Please, when creating a support Ticket, describes and explain what is your issue with the maximum detail possible!</p>
<p>A detailed description of what you want to ask, shortens the duration of time of resolution and avoids the waste of time on both sides</p>
<p>For issues related to accounts, specify facilitates the assignment of problem and also shortens the time.</p>';
$LNG['ti_create_head']						= 'Create Ticket';
$LNG['ti_category']							= 'Category';
$LNG['ti_subject']							= 'Subject';
$LNG['ti_message']							= 'Message';
$LNG['ti_submit']							= 'Send';
$LNG['ti_read']								= 'Ticket to read';
$LNG['ti_answer']							= 'Respond';
$LNG['ti_create']							= 'Ticket created on ';
$LNG['ti_responded']							= 'Ticket replied on ';
$LNG['ti_not_exist']						= 'Ticket #%d not found.';
$LNG['ti_from']								= 'by';
$LNG['ti_re']								= 'FW:';
$LNG['ti_error_no_subject']					= 'You must enter a subject!';
$LNG['ti_msgtime']							= 'Message posted at';

//----------------------------------------------------------------------------//
// Recordes

$LNG['rec_players']  						= 'Player';
$LNG['rec_level']  							= 'Level';
$LNG['rec_count']   						= 'Quantity';
$LNG['rec_last_update_on']		   			= 'Last update on ';

//----------------------------------------------------------------------------//
// Simulador de Batalha

$LNG['bs_derbis_raport']   					= "Required for recycling debris: %s %s.";
$LNG['bs_steal_raport']   					= "Required to capture resources: %s %s or %s %s.";
$LNG['bs_names']   							= "Ship Name";
$LNG['bs_atter']   							= "Attacker";
$LNG['bs_deffer']   						= "Defender";
$LNG['bs_steal']   							= "The defenders resources:";
$LNG['bs_techno']   						= "Technology";
$LNG['bs_send']   							= "Calculate";
$LNG['bs_cancel']   						= "Reset";
$LNG['bs_wait']   							= "Wait 10 seconds for the next simulation";
$LNG['bs_acs_slot']   						= 'ACS-Slot';
$LNG['bs_add_acs_slot']   					= 'Add ACS-Slot';
$LNG['bs_reset']							= 'Reset';
//----------------------------------------------------------------------------//
// Mercador de Naves

$LNG['ft_head']								= 'Merchant fleets';
$LNG['ft_count']							= 'Number';
$LNG['ft_max']								= 'max';
$LNG['ft_total']							= 'TOTAL';
$LNG['ft_charge']							= 'Merchant rate';
$LNG['ft_absenden']							= 'Send';
$LNG['ft_empty']							= 'Empty';

//----------------------------------------------------------------------------//
// Logout
$LNG['lo_title']							= 'Successfully logged out';
$LNG['lo_logout']							= 'Your session was terminated. Hopefully on purpose.';
$LNG['lo_redirect']							= 'Redirect';
$LNG['lo_notify']							= 'Will be redirected in <span id="seconds">5</span> seconds';
$LNG['lo_continue']							= 'Click to continue.';

//----------------------------------------------------------------------------//
