{block name="title" prepend}{$LNG.lm_alliance}{/block}
{block name="content"}

<!-- ===== HEADER ===== -->
<div class="page-header-wrapper mb-3">
    <img src="styles/theme/gow/img/headers/alliance_header.jpg" class="page-header-img" alt="">
</div>

<style>
/* ===== HEADER ===== */
.page-header-wrapper{
    width: 654px;
    height: 200px;
    margin: 0 auto 25px;
    border-radius: 10px;
    overflow: hidden;
    box-shadow: 0 0 12px rgba(0,0,0,.45);
}
.page-header-img{
    width: 100%;
    height: 100%;
    object-fit: cover;
}

/* ===== ANA KART ===== */
.nova-card {
    width: 100%;
    max-width: 900px;
    margin: 0 auto 25px;
    background: rgba(22,28,44,0.55);
    backdrop-filter: blur(8px);
    border: 1px solid rgba(120,150,255,0.25);
    border-radius: 14px;
    padding: 22px 26px;
    box-shadow: 0 0 12px rgba(0,0,0,0.45);
}

/* Başlık */
.nova-card-title {
    font-size: 18px;
    font-weight: bold;
    color: #9fc5ff;
    margin-bottom: 18px;
    text-align: center;
}

/* Grid */
.nova-grid {
    display: grid;
    grid-template-columns: 1fr 1fr;
    gap: 12px 25px;
    margin-bottom: 20px;
}

.nova-label{
    font-size: 13px;
    font-weight: bold;
    color:#c8d8ff;
}
.nova-value{
    font-size: 13px;
    font-weight: bold;
    color:#9cc4ff;
}

/* Kutu */
.nova-box{
    background: rgba(20,27,44,0.55);
    border-radius: 10px;
    padding: 14px;
    border: 1px solid rgba(130,150,220,0.25);
    margin-bottom: 20px;
    color: #e4e9ff;
    font-size: 13px;
}

.nova-sub-title{
    font-size: 15px;
    font-weight: bold;
    color: #9fc5ff;
    margin: 20px 0 10px 0;
}

/* Mini tablo */
.nova-mini-row{
    display: grid;
    grid-template-columns: 1fr 1fr 1fr 1fr;
    padding: 8px 0;
    border-bottom: 1px solid rgba(140,160,220,0.25);
}
.nova-mini-row div{
    color:#dfe7ff;
    font-size: 13px;
}

/* Butonlar */
.nova-btn{
    background: linear-gradient(90deg,#3a7bff,#5ea0ff);
    border:none;
    border-radius:10px;
    padding:8px 20px;
    color:#fff;
    font-weight:bold;
    cursor:pointer;
    transition:.2s;
    margin-right:5px;
}
.nova-btn:hover{
    transform:translateY(-2px);
    box-shadow:0 0 8px rgba(120,150,255,0.65);
}

/* Mesaj Alanı */
.nova-textarea{
    width:100%;
    background:rgba(20,25,40,0.75);
    border:1px solid rgba(140,170,255,0.35);
    border-radius:10px;
    color:#fff;
}
</style>


<!-- ========== BAŞVURU SAHİBİ BİLGİLERİ ========== -->
<div class="nova-card">

    <div class="nova-card-title">{sprintf($LNG.al_request_from,$applyDetail.username)} {$apply_time}</div>

    <div class="nova-grid">
        <div class="nova-label">{$LNG.pl_name}</div>
        <div class="nova-value">{$applyDetail.username}</div>

        <div class="nova-label">{$LNG.pl_homeplanet}</div>
        <div class="nova-value">
            {$applyDetail.name}
            <a href="#" onclick="parent.location='game.php?page=galaxy&galaxy={$applyDetail.galaxy}&system={$applyDetail.system}';return false;">
                [{$applyDetail.coordinates}]
            </a>
        </div>

        <div class="nova-label">{$LNG.al_request_register_time}</div>
        <div class="nova-value">{$register_time}</div>

        <div class="nova-label">{$LNG.al_request_last_onlinetime}</div>
        <div class="nova-value">{$onlinetime}</div>
    </div>

</div>


<!-- ========== PUANLAR ========== -->
<div class="nova-card">
    <div class="nova-sub-title">{$LNG.pl_points}</div>

    <div class="nova-mini-row">
        <div class="nova-label">{$LNG.pl_tech}</div>
        <div class="nova-value">{$applyDetail.tech_points}</div>
        <div class="nova-label">{$LNG.pl_range}</div>
        <div class="nova-value">{$applyDetail.tech_rank}</div>
    </div>

    <div class="nova-mini-row">
        <div class="nova-label">{$LNG.pl_builds}</div>
        <div class="nova-value">{$applyDetail.build_points}</div>
        <div class="nova-label">{$LNG.pl_range}</div>
        <div class="nova-value">{$applyDetail.build_rank}</div>
    </div>

    <div class="nova-mini-row">
        <div class="nova-label">{$LNG.pl_def}</div>
        <div class="nova-value">{$applyDetail.defs_points}</div>
        <div class="nova-label">{$LNG.pl_range}</div>
        <div class="nova-value">{$applyDetail.defs_rank}</div>
    </div>

    <div class="nova-mini-row">
        <div class="nova-label">{$LNG.pl_fleet}</div>
        <div class="nova-value">{$applyDetail.fleet_points}</div>
        <div class="nova-label">{$LNG.pl_range}</div>
        <div class="nova-value">{$applyDetail.fleet_rank}</div>
    </div>

    <div class="nova-mini-row">
        <div class="nova-label">{$LNG.pl_total}</div>
        <div class="nova-value">{$applyDetail.total_points}</div>
        <div class="nova-label">{$LNG.pl_range}</div>
        <div class="nova-value">{$applyDetail.total_rank}</div>
    </div>

</div>


<!-- ========== SAVAŞ İSTATİSTİKLERİ ========== -->
<div class="nova-card">

    <div class="nova-sub-title">{$LNG.pl_fightstats}</div>

    <div class="nova-mini-row">
        <div></div>
        <div class="nova-label">{$LNG.pl_fights}</div>
        <div class="nova-label">{$LNG.pl_fprocent}</div>
        <div></div>
    </div>

    <div class="nova-mini-row">
        <div class="nova-value">{$LNG.pl_fightwon}</div>
        <div class="nova-value">{$applyDetail.wons}</div>
        <div class="nova-value">{$applyDetail.wons_percentage} %</div>
        <div></div>
    </div>

    <div class="nova-mini-row">
        <div class="nova-value">{$LNG.pl_fightdraw}</div>
        <div class="nova-value">{$applyDetail.draws}</div>
        <div class="nova-value">{$applyDetail.draws_percentage} %</div>
        <div></div>
    </div>

    <div class="nova-mini-row">
        <div class="nova-value">{$LNG.pl_fightlose}</div>
        <div class="nova-value">{$applyDetail.loos}</div>
        <div class="nova-value">{$applyDetail.loos_percentage} %</div>
        <div></div>
    </div>

    <div class="nova-mini-row">
        <div class="nova-value">{$LNG.pl_totalfight}</div>
        <div class="nova-value">{$applyDetail.total_fights}</div>
        <div class="nova-value">100%</div>
        <div></div>
    </div>

    <div class="nova-mini-row">
        <div class="nova-value">{$LNG.pl_unitsshot}</div>
        <div class="nova-value">{$applyDetail.desunits}</div>
        <div></div><div></div>
    </div>

    <div class="nova-mini-row">
        <div class="nova-value">{$LNG.pl_unitslose}</div>
        <div class="nova-value">{$applyDetail.lostunits}</div>
        <div></div><div></div>
    </div>

    <div class="nova-mini-row">
        <div class="nova-value">{$LNG.pl_dermetal}</div>
        <div class="nova-value">{$applyDetail.kbmetal}</div>
        <div></div><div></div>
    </div>

    <div class="nova-mini-row">
        <div class="nova-value">{$LNG.pl_dercrystal}</div>
        <div class="nova-value">{$applyDetail.kbcrystal}</div>
        <div></div><div></div>
    </div>

</div>


<!-- ========== BAŞVURU MESAJI VARSA ========== -->
{if !empty($applyDetail.text)}
<div class="nova-card">
    <div class="nova-sub-title">{$LNG.al_message}</div>
    <div class="nova-box">{$applyDetail.text}</div>
</div>
{/if}


<!-- ========== YÖNETİCİ CEVAP FORMU ========== -->
<div class="nova-card">

    <div class="nova-sub-title">{$LNG.al_reply_to_request}</div>

    <form action="game.php?page=alliance&amp;mode=admin&amp;action=sendAnswerToApply&amp;id={$applyDetail.applyID}" method="post">

        <textarea name="text" rows="10" id="message" class="nova-textarea tinymce"></textarea>

        <br><br>

        <button type="submit" name="answer" value="yes" class="nova-btn">
            {$LNG.al_acept_request}
        </button>

        <button type="submit" name="answer" value="no" class="nova-btn" style="background:#c0392b;">
            {$LNG.al_decline_request}
        </button>

    </form>

</div>

{/block}

{block name="script" append}
<script type="text/javascript" src="scripts/base/tinymce/tiny_mce_gzip.js"></script>
<script>
$(function() {
    tinyMCE_GZ.init({
        plugins:'bbcode,fullscreen',
        themes:'advanced',
        languages:'{$lang}',
        disk_cache:true,
        debug:false
    },
    function(){
        tinyMCE.init({
            script_url:'scripts/base/tinymce/tiny_mce.js',
            theme:"advanced",
            mode:"textareas",
            plugins:"bbcode,fullscreen",
            theme_advanced_buttons1:"bold,italic,underline,undo,redo,link,unlink,image,forecolor,removeformat,cleanup,code,fullscreen",
            theme_advanced_toolbar_location:"top",
            theme_advanced_toolbar_align:"center",
            content_css:"{$dpath}formate.css",
            entity_encoding:"raw",
            fullscreen_new_window:false
        });
    });
});
</script>
{/block}
