{block name="title" prepend}{$LNG.lm_alliance}{/block}
{block name="content"}

<!-- ===== HEADER ===== -->
<div class="page-header-wrapper mb-3">
    <img src="styles/theme/gow/img/headers/alliance_header.jpg" class="page-header-img" alt="">
</div>

<style>
/* ===== HEADER TASARIM ===== */
.page-header-wrapper{
    width: 654px;
    height: 200px;
    margin: 0 auto 25px;
    border-radius: 10px;
    overflow: hidden;
    box-shadow: 0 0 12px rgba(0,0,0,.45);
}
.page-header-img{
    width: 100%;
    height: 100%;
    object-fit: cover;
}

/* ===== KART TASARIMI ===== */
.nova-card{
    width: 100%;
    max-width: 760px;
    margin: 0 auto;
    background: rgba(22,28,44,0.55);
    backdrop-filter: blur(8px);
    border: 1px solid rgba(120,150,255,0.25);
    border-radius: 14px;
    padding: 20px 25px;
    box-shadow: 0 0 12px rgba(0,0,0,0.45);
}

/* Başlık */
.nova-card-title{
    font-size: 17px;
    font-weight: bold;
    color: #9fc5ff;
    margin-bottom: 20px;
    text-align: center;
}

/* Label */
.nova-label{
    color: #c8d8ff;
    font-size: 14px;
    margin-bottom: 6px;
    display: block;
}

/* Textarea */
.nova-textarea{
    width: 100%;
    min-height: 180px;
    background: rgba(20,25,40,0.85);
    backdrop-filter: blur(4px);
    border: 1px solid rgba(140,170,255,0.35);
    border-radius: 12px;
    padding: 12px;
    color: #fff;
    resize: vertical;
}

/* Buton */
.nova-submit-btn{
    background: linear-gradient(90deg,#3a7bff,#5ea0ff);
    border: none;
    border-radius: 12px;
    padding: 8px 20px;
    color: #fff;
    font-weight: bold;
    cursor: pointer;
    transition: .2s;
    font-size: 14px;
    width: 100%;
    margin-top: 20px;
}
.nova-submit-btn:hover{
    transform: translateY(-2px);
    box-shadow: 0 0 8px rgba(130,160,255,0.65);
}
</style>

<div class="nova-card">

    <div class="nova-card-title">{$al_write_request}</div>

    <form action="game.php?page=alliance&amp;mode=apply&amp;id={$allyid}" method="post">

        <label class="nova-label" for="message">{$LNG.al_message}</label>

        <textarea 
            name="text"
            cols="40"
            rows="10"
            class="tinymce nova-textarea"
            id="message">{$applytext}</textarea>

        <input class="nova-submit-btn" type="submit" value="{$LNG.al_applyform_send}">
    </form>

</div>

{/block}

{block name="script" append}
<script type="text/javascript" src="scripts/base/tinymce/tiny_mce_gzip.js"></script>
<script type="text/javascript">
$(function() {
	tinyMCE_GZ.init({
		plugins : 'bbcode,fullscreen',
		themes : 'advanced',
		languages : '{$lang}',
		disk_cache : true,
		debug : false
	}, function() {
		tinyMCE.init({
			script_url : 'scripts/base/tinymce/tiny_mce.js',
			theme : "advanced",
			mode : "textareas",
			plugins : "bbcode,fullscreen",
			theme_advanced_buttons1 : "bold,italic,underline,undo,redo,link,unlink,image,forecolor,removeformat,cleanup,code,fullscreen",
			theme_advanced_buttons2 : "",
			theme_advanced_buttons3 : "",
			theme_advanced_toolbar_location : "top",
			theme_advanced_toolbar_align : "center",
			theme_advanced_styles : "Code=codeStyle;Quote=quoteStyle",
			content_css : "{$dpath}formate.css",
			entity_encoding : "raw",
			add_unload_trigger : false,
			remove_linebreaks : false,
			fullscreen_new_window : false,
			fullscreen_settings : {
				theme_advanced_path_location : "top"
			}
		});
	});
});
</script>
{/block}
