{block name="title" prepend}{$LNG.lm_alliance}{/block}
{block name="content"}

<!-- ===== HEADER ===== -->
<div class="page-header-wrapper mb-3">
    <img src="styles/theme/gow/img/headers/alliance_header.jpg" class="page-header-img" alt="">
</div>

<style>
/* ===== HEADER ===== */
.page-header-wrapper{
    width: 654px;
    height: 200px;
    margin: 0 auto 25px;
    border-radius: 10px;
    overflow: hidden;
    box-shadow: 0 0 12px rgba(0,0,0,.45);
}
.page-header-img{
    width: 100%;
    height: 100%;
    object-fit: cover;
}

/* ===== ANA KART ===== */
.nova-card{
    width: 100%;
    max-width: 880px;
    margin: 0 auto 20px;
    background: rgba(22,28,44,0.55);
    backdrop-filter: blur(8px);
    border: 1px solid rgba(120,150,255,0.25);
    border-radius: 14px;
    padding: 22px 26px;
    box-shadow: 0 0 12px rgba(0,0,0,0.45);
}

/* Başlık */
.nova-card-title{
    font-size: 18px;
    font-weight: bold;
    color: #9fc5ff;
    margin-bottom: 18px;
    text-align: center;
}

/* Grid sistem */
.nova-grid{
    display: grid;
    grid-template-columns: 1fr 1fr;
    gap: 12px 25px;
    margin-bottom: 20px;
}

.nova-label{
    font-size: 13px;
    font-weight: bold;
    color: #c8d8ff;
}
.nova-value{
    font-size: 13px;
    font-weight: bold;
    color: #9cc4ff;
}

/* Kutu */
.nova-box{
    background: rgba(20,27,44,0.55);
    border-radius: 10px;
    padding: 14px;
    border: 1px solid rgba(130,150,220,0.25);
    margin-bottom: 20px;
    color: #e4e9ff;
    font-size: 13px;
}

/* Alt başlık */
.nova-sub-title{
    font-size: 15px;
    font-weight: bold;
    color: #9fc5ff;
    margin: 15px 0 10px 0;
}

/* Buton */
.nova-btn{
    display: inline-block;
    background: linear-gradient(90deg,#3a7bff,#5ea0ff);
    padding: 6px 14px;
    border-radius: 10px;
    color: #fff;
    font-weight: bold;
    font-size: 13px;
    text-decoration: none;
    transition: .2s;
}
.nova-btn:hover{
    transform: translateY(-3px);
    box-shadow: 0 0 10px rgba(120,150,255,0.5);
}
</style>

<div class="nova-card">

    <div class="nova-card-title">{$LNG.al_ally_information}</div>

    {if $ally_image}
    <div style="text-align:center;margin-bottom:20px;">
        <img src="{$ally_image}" alt="{$ally_tag}" style="max-width:100%;border-radius:10px;">
    </div>
    {/if}

    <!-- ===== GENEL BİLGİLER ===== -->
    <div class="nova-grid">
        <div class="nova-label">{$LNG.al_ally_info_tag}</div>
        <div class="nova-value">{$ally_tag}</div>

        <div class="nova-label">{$LNG.al_ally_info_name}</div>
        <div class="nova-value">{$ally_name}</div>

        <div class="nova-label">{$LNG.al_ally_info_members}</div>
        <div class="nova-value">{$ally_member_scount} / {$ally_max_members}</div>
    </div>

    <!-- ===== BAŞVURU ===== -->
    {if $ally_request}
        <div class="nova-sub-title">{$LNG.al_request}</div>
        <div class="nova-box">
            {if $ally_request_min_points}
                <a class="nova-btn" href="game.php?page=alliance&amp;mode=apply&amp;id={$ally_id}">{$LNG.al_click_to_send_request}</a>
            {else}
                {$ally_request_min_points_info}
            {/if}
        </div>
    {/if}

    <!-- ===== AÇIKLAMA ===== -->
    <div class="nova-sub-title">{$LNG.al_description_message}</div>
    <div class="nova-box">
        {if !empty($ally_description)}
            {$ally_description}
        {else}
            {$LNG.al_description_message}
        {/if}
    </div>

    <!-- ===== WEB ===== -->
    {if $ally_web}
        <div class="nova-sub-title">{$LNG.al_web_text}</div>
        <div class="nova-box">
            <a href="{$ally_web}" target="_blank" style="color:#9dc9ff;">{$ally_web}</a>
        </div>
    {/if}

    <!-- ===== DİPLOMASİ ===== -->
    {if $diplomaticData}
        <div class="nova-sub-title">{$LNG.al_diplo}</div>
        <div class="nova-box">

            {if !empty($diplomaticData.0)}
                <b><u>{$LNG.al_diplo_level.0}</u></b><br>
                {foreach item=PaktInfo from=$diplomaticData.0}
                    <a href="?page=alliance&mode=info&amp;id={$PaktInfo.1}" style="color:#9dc9ff;">{$PaktInfo.0}</a><br>
                {/foreach}
                <br>
            {/if}

            {if !empty($diplomaticData.1)}
                <b><u>{$LNG.al_diplo_level.1}</u></b><br>
                {foreach item=PaktInfo from=$diplomaticData.1}
                    <a href="?page=alliance&mode=info&amp;id={$PaktInfo.1}" style="color:#9dc9ff;">{$PaktInfo.0}</a><br>
                {/foreach}
                <br>
            {/if}

            {if !empty($diplomaticData.2)}
                <b><u>{$LNG.al_diplo_level.2}</u></b><br>
                {foreach item=PaktInfo from=$diplomaticData.2}
                    <a href="?page=alliance&mode=info&amp;id={$PaktInfo.1}" style="color:#9dc9ff;">{$PaktInfo.0}</a><br>
                {/foreach}
                <br>
            {/if}

            {if !empty($diplomaticData.3)}
                <b><u>{$LNG.al_diplo_level.3}</u></b><br>
                {foreach item=PaktInfo from=$diplomaticData.3}
                    <a href="?page=alliance&mode=info&amp;id={$PaktInfo.1}" style="color:#9dc9ff;">{$PaktInfo.0}</a><br>
                {/foreach}
                <br>
            {/if}

            {if !empty($diplomaticData.4)}
                <b><u>{$LNG.al_diplo_level.4}</u></b><br>
                {foreach item=PaktInfo from=$diplomaticData.4}
                    <a href="?page=alliance&mode=info&amp;id={$PaktInfo.1}" style="color:#9dc9ff;">{$PaktInfo.0}</a><br>
                {/foreach}
            {/if}

        </div>
    {/if}

    <!-- ===== SAVAŞ İSTATİSTİKLERİ ===== -->
    {if !empty($statisticData)}
        <div class="nova-sub-title">{$LNG.pl_fightstats}</div>
        <div class="nova-box">
            <div><b>{$LNG.pl_totalfight}:</b> {$statisticData.totalfight|number}</div>
            <div><b>{$LNG.pl_fightwon}:</b> {$statisticData.fightwon|number}{if $statisticData.totalfight} ({round($statisticData.fightwon / $statisticData.totalfight * 100, 2)}%){/if}</div>
            <div><b>{$LNG.pl_fightlose}:</b> {$statisticData.fightlose|number}{if $statisticData.totalfight} ({round($statisticData.fightlose / $statisticData.totalfight * 100, 2)}%){/if}</div>
            <div><b>{$LNG.pl_fightdraw}:</b> {$statisticData.fightdraw|number}{if $statisticData.totalfight} ({round($statisticData.fightdraw / $statisticData.totalfight * 100, 2)}%){/if}</div>
            <div><b>{$LNG.pl_unitsshot}:</b> {$statisticData.unitsshot}</div>
            <div><b>{$LNG.pl_unitslose}:</b> {$statisticData.unitslose}</div>
            <div><b>{$LNG.pl_dermetal}:</b> {$statisticData.dermetal}</div>
            <div><b>{$LNG.pl_dercrystal}:</b> {$statisticData.dercrystal}</div>
        </div>
    {/if}

</div>

{/block}
