{block name="title" prepend}{$LNG.lm_alliance}{/block}
{block name="content"}

<!-- ===== HEADER ===== -->
<div class="page-header-wrapper mb-3">
    <img src="styles/theme/gow/img/headers/alliance_header.jpg" class="page-header-img" alt="">
</div>

<style>
/* ===== HEADER ===== */
.page-header-wrapper{
    width: 654px;
    height: 200px;
    margin: 0 auto 25px;
    border-radius: 10px;
    overflow: hidden;
    box-shadow: 0 0 12px rgba(0,0,0,.45);
}
.page-header-img{
    width: 100%;
    height: 100%;
    object-fit: cover;
}

/* ===== ANA KART ===== */
.nova-card{
    width: 100%;
    max-width: 900px;
    margin: 0 auto 25px;
    background: rgba(22,28,44,0.55);
    backdrop-filter: blur(8px);
    border: 1px solid rgba(120,150,255,0.25);
    border-radius: 14px;
    padding: 22px 26px;
    box-shadow: 0 0 12px rgba(0,0,0,0.45);
}

/* Başlık */
.nova-card-title{
    font-size: 18px;
    font-weight: bold;
    color: #9fc5ff;
    margin-bottom: 18px;
    text-align: center;
}

/* ===== TABLO ===== */

.nova-table-wrapper{
    overflow-x: auto;
}

.nova-table{
    width: 100%;
    border-collapse: collapse;
}

.nova-table thead th{
    background: rgba(40,50,70,0.75);
    color: #dfe7ff;
    padding: 10px;
    font-size: 13px;
    text-align: center;
    border-bottom: 1px solid rgba(120,150,255,0.25);
}

.nova-table tbody td{
    padding: 10px 6px;
    color: #e7edff;
    font-size: 13px;
    border-bottom: 1px solid rgba(120,150,255,0.18);
    text-align: center;
}

.nova-table tbody tr:hover{
    background: rgba(120,150,255,0.10);
    transition: .2s;
}

.nova-table a{
    color: #9cc4ff;
    font-weight: bold;
    text-decoration: none;
}
.nova-table a:hover{
    color: #cfe3ff;
}

/* ===== Geri Dön Linki ===== */
.nova-back{
    display:block;
    margin-top:15px;
    text-align:center;
    background: rgba(40,50,80,0.7);
    padding:10px;
    color:#e0ecff;
    font-weight:bold;
    border-radius:10px;
    border:1px solid rgba(120,150,255,0.35);
    transition:.2s;
    text-decoration:none;
}
.nova-back:hover{
    background: rgba(80,110,160,0.8);
    color:#fff;
    transform: translateY(-2px);
}

</style>

<div class="nova-card">
    <div class="nova-card-title">{$al_users_list}</div>

    <div class="nova-table-wrapper">
        <table id="memberList" class="nova-table">
            <thead>
                <tr>
                    <th>{$LNG.al_num}</th>
                    <th>{$LNG.al_member}</th>
                    <th>{$LNG.al_message}</th>
                    <th>{$LNG.al_position}</th>
                    <th>{$LNG.al_points}</th>
                    <th>{$LNG.al_coords}</th>
                    <th>{$LNG.al_member_since}</th>
                    <th>{$LNG.al_estate}</th>
                </tr>
            </thead>
            <tbody>
                {foreach $memberList as $userID => $memberListRow}
                <tr>
                    <td>{$memberListRow@iteration}</td>

                    <td>
                        <a href="#" onclick="return Dialog.Playercard({$userID}, '{$memberListRow.username}');">
                            {$memberListRow.username}
                        </a>
                        {if !empty($memberListRow.class)}
                            {foreach $memberListRow.class as $class}
                                {if !$class@first}&nbsp;{/if}
                                <span class="galaxy-short-{$class} galaxy-short">{$ShortStatus.$class}</span>
                            {/foreach}
                        {/if}
                    </td>

                    <td>
                        <a href="#" onclick="return Dialog.PM({$userID});">
                            <img src="{$dpath}img/m.gif" border="0">
                        </a>
                    </td>

                    <td>{$memberListRow.rankName}</td>

                    <td class="points" data-points="{$memberListRow.points}">
                        {$memberListRow.points}
                    </td>

                    <td>
                        <a href="game.php?page=galaxy&amp;galaxy={$memberListRow.galaxy}&amp;system={$memberListRow.system}">
                            [{$memberListRow.galaxy}:{$memberListRow.system}:{$memberListRow.planet}]
                        </a>
                    </td>

                    <td>{$memberListRow.register_time}</td>

                    <td>
                        {if $rights.ONLINESTATE}
                            {if $memberListRow.onlinetime < 4}
                                <span style="color:lime">{$LNG.al_memberlist_on}</span>
                            {elseif $memberListRow.onlinetime <= 15}
                                <span style="color:yellow">{$memberListRow.onlinetime} {$LNG.al_memberlist_min}</span>
                            {else}
                                <span style="color:red">{$LNG.al_memberlist_off}</span>
                            {/if}
                        {else}
                            -
                        {/if}
                    </td>
                </tr>
                {/foreach}
            </tbody>
        </table>
    </div>

    <a class="nova-back" href="game.php?page=alliance">{$LNG.al_back}</a>

</div>

{/block}


{block name="script" append}
<script src="scripts/base/jquery.tablesorter.js"></script>
<script>
$(function() {

    /* Sıralayıcı parser */
	$.tablesorter.addParser({
		id: 'status',
		is: function(s){ return false; },
	    format: function(s){
		    if(s=="{$LNG.al_memberlist_on}") return 0;
	        if(s=="{$LNG.al_memberlist_off}") return 999;
		    var lNumber = parseFloat(s.replace(/[^0-9]/,''));
		    return lNumber;
	    },
	    type: 'numeric'
	});

    /* Sıralama aktif */
    $("#memberList").tablesorter({
        headers:{
            0:{ sorter:false },
            3:{ sorter:false },
            7:{ sorter:"status" }
        },
        debug:false
    });

    /* Puan formatlama */
    var elements = document.getElementsByClassName('points');
    for (var i = 0, l = elements.length; i < l; i++) {
        elements[i].innerHTML = number_format(elements[i].innerHTML);
    }

});
</script>
{/block}
