{block name="title" prepend}{$LNG.lm_fleet}{/block}
{block name="content"}

<style>
/* ==== NOVAPUS FLEET STEP 3 ==== */

.nf3-wrapper {
    background: #0d0f14;
    border: 1px solid #20252f;
    padding: 20px;
    border-radius: 6px;
    margin-bottom: 20px;
}

.nf3-title {
    font-size: 17px;
    font-weight: 600;
    color: #d0d6e2;
    margin-bottom: 10px;
}

.nf3-summary {
    display: flex;
    align-items: center;
    gap: 15px;
    padding: 12px;
    background: #131720;
    border: 1px solid #222835;
    border-radius: 6px;
    margin-bottom: 20px;
}

.nf3-summary-icon {
    width: 42px;
    height: 42px;
    object-fit: contain;
}

.nf3-summary-text {
    font-size: 15px;
    color: #cdd3df;
}

.nf3-info-grid {
    display: grid;
    grid-template-columns: repeat(3, 1fr);
    gap: 12px;
    margin-top: 15px;
    margin-bottom: 25px;
}

.nf3-info-box {
    padding: 12px;
    background: #131720;
    border: 1px solid #222835;
    border-radius: 6px;
}

.nf3-info-title {
    font-size: 12px;
    color: #9aa3b5;
}

.nf3-info-value {
    font-size: 15px;
    font-weight: 600;
    color: #d0d6e2;
}

.nf3-ship-list {
    margin-top: 10px;
}

.nf3-ship-row {
    display: flex;
    justify-content: space-between;
    padding: 8px 10px;
    background: #11141b;
    border-bottom: 1px solid #1c212d;
    color: #d0d6e2;
}

.nf3-btn-send {
    margin-top: 20px;
    width: 100%;
    background: #3a963c;
    border: 0;
    padding: 10px;
    color: white;
    border-radius: 6px;
    font-size: 15px;
    font-weight: 600;
    cursor: pointer;
}

.nf3-btn-send:hover {
    background: #2f7d32;
}
</style>



<!-- =============================== -->
<!--         GÖREV ÖZETİ            -->
<!-- =============================== -->
<div class="nf3-wrapper">
    <div class="nf3-title">{$LNG.fl_fleet_sended}</div>

    <div class="nf3-summary">
        <img src="styles/theme/gow/img/{$targetMission}.png" class="nf3-summary-icon">
        <div class="nf3-summary-text">
            {$LNG["type_mission_{$targetMission}"]}<br>
            {$from} → {$destination}
        </div>
    </div>


    <!-- =============================== -->
    <!--        BİLGİ KUTULARI           -->
    <!-- =============================== -->
    <div class="nf3-info-grid">

        <div class="nf3-info-box">
            <div class="nf3-info-title">{$LNG.fl_distance}</div>
            <div class="nf3-info-value">{$distance|number}</div>
        </div>

        <div class="nf3-info-box">
            <div class="nf3-info-title">{$LNG.fl_fleet_speed}</div>
            <div class="nf3-info-value">{$MaxFleetSpeed|number}</div>
        </div>

        <div class="nf3-info-box">
            <div class="nf3-info-title">{$LNG.fl_fuel_consumption}</div>
            <div class="nf3-info-value">{$consumption|number}</div>
        </div>

        <div class="nf3-info-box">
            <div class="nf3-info-title">{$LNG.fl_arrival_time}</div>
            <div class="nf3-info-value">{$fleetStartTime}</div>
        </div>

        <div class="nf3-info-box">
            <div class="nf3-info-title">{$LNG.fl_return_time}</div>
            <div class="nf3-info-value">{$fleetEndTime}</div>
        </div>

    </div>


    <!-- =============================== -->
    <!--            FİLO LİSTESİ         -->
    <!-- =============================== -->
    <div class="nf3-title">{$LNG.fl_fleet}</div>

    <div class="nf3-ship-list">
        {foreach $FleetList as $ShipID => $ShipCount}
        <div class="nf3-ship-row">
            <span>{$LNG.tech.{$ShipID}}</span>
            <span>{$ShipCount|number}</span>
        </div>
        {/foreach}
    </div>


</div>


<!-- =============================== -->
<!--          GÖNDER BUTONU         -->
<!-- =============================== -->
<form action="">
    <button class="nf3-btn-send">{$LNG.fl_continue}</button>
</form>

{/block}
