{block name="title"}Market{/block}
{block name="content"}

<!-- HEADER -->
<div class="page-header-wrapper mb-3">
    <img src="styles/theme/gow/img/headers/market_header.jpg" class="page-header-img" alt="">
</div>

<style>
    .page-header-wrapper{
    width: 654px;
    height: 200px;
    margin: 0 auto 25px;
    border-radius: 6px;
    overflow: hidden;
    box-shadow: 0 0 12px rgba(0,0,0,.45);
}

.page-header-img{
    width: 100%;
    height: 100%;
    object-fit: cover;
}
</style>

<link rel="stylesheet" href="styles/theme/gow/market.css">

<div class="nova-market-container">

	<!-- Sekmeler -->
	<div class="nova-market-tabs">
		<button class="tab-btn active" data-tab="dm">Karanlık Madde</button>
		<button class="tab-btn" data-tab="resources">Kaynak Paketleri</button>
		<button class="tab-btn" data-tab="boosts">Hızlandırıcılar</button>
	</div>

	<!-- === DM PAKETLERİ === -->
	<div class="nova-tab active" id="tab-dm">
		<div class="market-grid">
			{foreach $dmPacks as $p}
			<div class="market-card">
				<img src="styles/theme/gow/images/market/{$p.image}" class="market-img">
				<h3>{$p.title}</h3>
				{if $p.desc != ''}<p>{$p.desc}</p>{/if}
				<p class="market-price">{$p.price}</p>

				<a href="javascript:void(0);" class="buy-btn" onclick="openBuyWindow('{$p.id}'); return false;">
					Satın Al
				</a>
			</div>
			{/foreach}
		</div>
	</div>

	<!-- === KAYNAK PAKETLERİ === -->
	<div class="nova-tab" id="tab-resources">
		<div class="market-grid">
			{foreach $resourcePacks as $p}
			<div class="market-card">
				<img src="styles/theme/gow/images/market/{$p.image}" class="market-img">
				<h3>{$p.title}</h3>
				<p>{$p.desc}</p>
				<p class="market-price">{$p.price}</p>

				<a href="javascript:void(0);" class="buy-btn" onclick="openBuyWindow('{$p.id}'); return false;">
					Satın Al
				</a>
			</div>
			{/foreach}
		</div>
	</div>

	<!-- === BOOSTER PAKETLERİ === -->
	<div class="nova-tab" id="tab-boosts">
		<div class="market-grid">
			{foreach $boosters as $p}
			<div class="market-card">
				<img src="styles/theme/gow/images/market/{$p.image}" class="market-img">
				<h3>{$p.title}</h3>
				<p>{$p.desc}</p>
				<p class="market-price">{$p.price}</p>

				<a href="javascript:void(0);" class="buy-btn" onclick="openBuyWindow('{$p.id}'); return false;">
					Satın Al
				</a>
			</div>
			{/foreach}
		</div>
	</div>

</div>

<!-- === SHOPIER POPUP === -->
<div id="nova-market-payment" class="payment-popup">
	<div class="payment-box">
		<h4>Shopier ile Satın Al</h4>
		<p>Bu paketi Shopier üzerinden satın almak istiyor musunuz?</p>

		<button id="nova-pay-shopier" class="buy-btn w-100 mb-2" style="background:#ff6c00;">
			Shopier ile Öde
		</button>

		<button id="nova-pay-close" class="close-btn">İptal</button>
	</div>
</div>

<script>
// =========================
//   SEKME KONTROLÜ
// =========================
document.querySelectorAll(".nova-market-tabs .tab-btn").forEach(btn => {
	btn.addEventListener("click", function() {

		document.querySelectorAll(".tab-btn").forEach(b => b.classList.remove("active"));
		this.classList.add("active");

		document.querySelectorAll(".nova-tab").forEach(tab => tab.classList.remove("active"));
		const target = "tab-" + this.dataset.tab;
		document.getElementById(target).classList.add("active");
	});
});

// =========================
//   SHOPIER POPUP LOGİĞİ
// =========================
let novaCurrentPackageId = 0;

function openBuyWindow(id) {
	id = Number(id);
	if (isNaN(id) || id <= 0) {
		alert("HATALI ID: " + id);
		return;
	}

	novaCurrentPackageId = id;

	const popup = document.getElementById("nova-market-payment");
	popup.style.display = "flex";
}

document.addEventListener("DOMContentLoaded", function () {

	const popup = document.getElementById("nova-market-payment");
	const btnShopier = document.getElementById("nova-pay-shopier");
	const btnClose = document.getElementById("nova-pay-close");

	btnShopier.onclick = function (e) {
		e.stopPropagation();
		window.location.href =
			"game.php?page=market&mode=buy&id=" + novaCurrentPackageId + "&method=shopier";
	};

	btnClose.onclick = function () {
		popup.style.display = "none";
	};

	popup.addEventListener("click", function (e) {
		if (e.target === popup) popup.style.display = "none";
	});
});
</script>

{/block}
