{block name="title" prepend}{$LNG.lm_officiers}{/block}
{block name="content"}

<!-- HEADER -->
<div class="page-header-wrapper mb-3">
    <img src="styles/theme/gow/img/headers/officers_header.jpg" class="page-header-img" alt="">
</div>

<style>
.page-header-wrapper{
    width: 654px;
    height: 200px;
    margin: 0 auto 25px;
    border-radius: 6px;
    overflow: hidden;
    box-shadow: 0 0 12px rgba(0,0,0,.45);
}
.page-header-img{
    width: 100%;
    height: 100%;
    object-fit: cover;
}

/* === MODERN SUBAY KART TASARIMI + 3D HOVER === */
.officer-card {
    background: linear-gradient(180deg, #1a1f2b 0%, #0f131a 100%);
    border: 1px solid rgba(255,255,255,0.08);
    border-radius: 10px;
    padding: 15px;
    margin-bottom: 18px;
    box-shadow: 0 6px 16px rgba(0,0,0,0.45);
    transition: 0.25s all ease;
    transform-style: preserve-3d;
}
.officer-card:hover {
    transform: translateY(-4px) scale(1.01);
    box-shadow: 0 14px 30px rgba(0,0,0,0.7);
}

/* Üst kısım: resim + bilgiler */
.officer-top {
    display: flex;
    gap: 15px;
    margin-bottom: 10px;
}

/* Sol taraf: resim */
.officer-left {
    display: flex;
    flex-direction: column;
    align-items: center;
    width: 140px;
}
.officer-img {
    width: 120px;
    height: 120px;
    border-radius: 6px;
    object-fit: cover;
    box-shadow: 0 0 8px rgba(0,0,0,0.5);
}

/* Sağ taraf: isim, açıklama, bonuslar */
.officer-right {
    flex: 1;
}

.officer-name {
    font-size: 16px;
    color: #d9e8ff;
    font-weight: bold;
    margin-bottom: 4px;
    text-shadow: 0 0 4px rgba(0,123,255,0.5);
}

.officer-desc {
    font-size: 12px;
    color: #a4b2c7;
    margin-bottom: 6px;
}

.officer-bonus {
    background: rgba(0, 110, 255, 0.12);
    border-left: 3px solid #007bff;
    padding: 6px 10px;
    border-radius: 5px;
    font-size: 12px;
    color: #c7ddff;
    margin-bottom: 4px;
}

/* BONUS İKONLARI */
.bonus-line {
    display: flex;
    align-items: center;
    gap: 6px;
}
.bonus-icon {
    width: 16px;
    text-align: center;
    font-size: 12px;
    opacity: 0.85;
}
.bonus-icon[data-key^="mine_"]::before      { content:"⛏"; }
.bonus-icon[data-key^="storage_"]::before   { content:"📦"; }
.bonus-icon[data-key^="fleet_"]::before     { content:"🚀"; }
.bonus-icon[data-key^="ship_"]::before      { content:"🚀"; }
.bonus-icon[data-key^="defense_"]::before   { content:"🛡"; }
.bonus-icon[data-key^="exp_"]::before       { content:"🌀"; }
.bonus-icon[data-key^="Resource"]::before   { content:"⚙"; }
.bonus-icon[data-key^="Energy"]::before     { content:"⚡"; }
.bonus-icon[data-key^="ShipStorage"]::before{ content:"🚢"; }
.bonus-icon[data-key^="FleetSlots"]::before { content:"📡"; }
.bonus-icon[data-key^="MoreFound"]::before  { content:"✨"; }
.bonus-icon::before {
    content: attr(data-icon);
}

/* === ALT KISIM: 7 / 30 / 90 GÜN BUTONLARI === */
.officer-pack-row {
    display: flex;
    gap: 8px;
    width: 100%;
    margin-top: 6px;
}
.officer-pack-form {
    flex: 1;
}

/* BUTON TASARIMI */
.officer-btn {
    background: linear-gradient(90deg, #1565ff, #3a8bff);
    border: none;
    padding: 6px 8px;
    border-radius: 8px;
    font-size: 11px;
    font-weight: bold;
    color: white;
    box-shadow: 0 0 8px rgba(21, 101, 255, 0.5);
    transition: 0.2s all ease;
    width: 100%;
    text-align: center;
    white-space: nowrap;
}
.officer-btn:hover {
    transform: translateY(-2px);
    box-shadow: 0 0 14px rgba(21, 101, 255, 0.9);
    cursor: pointer;
}
.officer-btn:active {
    transform: scale(0.96);
}

/* TIMER */
.officer-timer {
    display: inline-block;
    margin-left: 6px;
    padding: 2px 6px;
    border-radius: 4px;
    font-weight: bold;
    background: rgba(0,255,0,0.12);
    color: #00ff84;
}

/* 24 SAAT UYARISI */
.timer-warning {
    background: rgba(255,180,0,0.12);
    color: #ffcc33 !important;
    animation: pulseYellow 1s infinite;
}
@keyframes pulseYellow {
    0% { box-shadow: 0 0 0 rgba(255,200,0,0.3); }
    50% { box-shadow: 0 0 12px rgba(255,200,0,0.7); }
    100% { box-shadow: 0 0 0 rgba(255,200,0,0.3); }
}

/* SÜRE BİTTİ */
.timer-expired {
    background: rgba(255,0,0,0.2);
    color: #ff5b5b !important;
    animation: pulseRed 1s infinite;
}
@keyframes pulseRed {
    0% { box-shadow: 0 0 0 rgba(255,0,0,0.3); }
    50% { box-shadow: 0 0 12px rgba(255,0,0,0.7); }
    100% { box-shadow: 0 0 0 rgba(255,0,0,0.3); }
}

/* Mobil uyum */
@media(max-width: 768px){
    .officer-top{
        flex-direction: column;
        align-items: center;
    }
    .officer-left{
        width: 100%;
    }
}
.my-officers-box{
    background: rgba(10,15,25,0.9);
    border: 1px solid rgba(255,255,255,0.06);
    border-radius: 10px;
    padding: 10px 14px;
    margin-bottom: 20px;
    box-shadow: 0 0 10px rgba(0,0,0,0.4);
}

.my-officers-title{
    font-size: 13px;
    font-weight: bold;
    color: #d9e8ff;
    margin-bottom: 8px;
    text-transform: uppercase;
    letter-spacing: 0.05em;
}

.my-officer-row{
    display: flex;
    justify-content: space-between;
    align-items: center;
    font-size: 12px;
    padding: 3px 0;
    border-bottom: 1px dashed rgba(255,255,255,0.07);
}
.my-officer-row:last-child{
    border-bottom: none;
}

.my-officer-name{
    color: #c3d4f3;
}

.my-officer-empty{
    font-size: 12px;
    color: #7f8aa0;
}
/* ==== AKTIF SUBAY 48x48 İKONLARI ==== */

.my-officers-box{
    background: rgba(10,15,25,0.9);
    border: 1px solid rgba(255,255,255,0.06);
    border-radius: 10px;
    padding: 10px 14px;
    margin-bottom: 20px;
    box-shadow: 0 0 10px rgba(0,0,0,0.4);
}

.my-officers-title{
    font-size: 13px;
    font-weight: bold;
    color: #d9e8ff;
    margin-bottom: 8px;
    text-transform: uppercase;
    letter-spacing: 0.05em;
}

.my-officers-icon-row{
    display: flex;
    gap: 10px;
    flex-wrap: wrap;
}

.my-officer-icon{
    width: 48px;
    display: flex;
    flex-direction: column;
    align-items: center;
    cursor: pointer;
    transition: 0.2s;
}
.my-officer-icon:hover{
    transform: scale(1.15);
}

.my-officer-img{
    width: 48px;
    height: 48px;
    border-radius: 6px;
    object-fit: cover;
    box-shadow: 0 0 8px rgba(0,0,0,0.5);
}

.my-officer-timer{
    margin-top: 3px;
    font-size: 10px;
    background: rgba(0,255,0,0.15);
    color: #00ff84;
    padding: 1px 3px;
    border-radius: 4px;
}

.my-officer-empty{
    font-size: 12px;
    color: #7f8aa0;
}

</style>

{* === AKTIF SUBAYLARIM - 48x48 İKON LİSTESİ === *}
<div class="my-officers-box mb-3">

    <div class="my-officers-title">Aktif subaylarım</div>
    
    {assign var=hasActive value=false}

    <div class="my-officers-icon-row">
        {assign var=hasActive value=false}

        {foreach $officierList as $AO}
            {if $AO.timeLeft > 0}
                {assign var=hasActive value=true}

                <div class="my-officer-icon"
     onclick="document.getElementById('officer_card_{$AO.id}').scrollIntoView(true);">

                    <img src="styles/theme/gow/img/officers/{$AO.image}"
                         alt="{$AO.name}" class="my-officer-img">

                    <span class="my-officer-timer officer-timer"
                          id="my_timer_{$AO.id}"
                          data-seconds="{$AO.timeLeft}">
                    </span>
                </div>

            {/if}
        {/foreach}

        {if !$hasActive}
            <div class="my-officer-empty">Aktif subayın yok.</div>
        {/if}

    </div>
</div>


{* BONUS KEY → TÜRKÇE METİN TABLOSU *}
{assign var="BONUS_TRANSLATE" value=[
    'mine_metal'       => 'Metal üretimi',
    'mine_crystal'     => 'Kristal üretimi',
    'mine_deuterium'   => 'Deuterium üretimi',
    'mine_energy'      => 'Enerji üretimi',
    'mine_all'         => 'Tüm kaynak üretimi',

    'storage_metal'    => 'Metal depo kapasitesi',
    'storage_crystal'  => 'Kristal depo kapasitesi',
    'storage_deuterium'=> 'Deuterium depo kapasitesi',
    'storage_all'      => 'Genel depo kapasitesi',

    'ship_speed'       => 'Gemi hızı',
    'fleet_speed'      => 'Filo hızı',
    'fleet_fuel_use'   => 'Yakıt tüketimi',
    'fleet_attack'     => 'Filo saldırı gücü',
    'fleet_defense'    => 'Filo savunma gücü',

    'exp_event_chance'      => 'İyi event şansı',
    'exp_find_rate'         => 'Kaynak bulma oranı',
    'exp_dm_find_rate'      => 'DM bulma oranı',
    'exp_dm_multiplier'     => 'DM çarpanı',
    'exp_ship_find_rate'    => 'Gemi bulma ihtimali',
    'exp_fleet_loss_reduce' => 'Kayıp azaltma',
    'exp_time_reduce'       => 'Dönüş süresi azaltma',

    'exp_more'         => 'Ekstra DM bulma',
    'Resource'         => 'Genel üretim bonusu',
    'Energy'           => 'Genel enerji bonusu',

    'ShipStorage'      => 'Gemi depolama kapasitesi',
    'FlyTime'          => 'Uçuş süresi',
    'FleetSlots'       => 'Filo slotu',
    'MoreFound'        => 'Ekstra keşif bonusu'
]}

{* === AKTIF SUBAYLARIM ÖZET KUTUSU === *}
<div class="my-officers-box mb-3">
    <div class="my-officers-title">Aktif subaylarım</div>

    {assign var=hasActive value=false}
    {foreach $officierList as $AO}
        {if $AO.timeLeft > 0}
            {assign var=hasActive value=true}
            <div class="my-officer-row">
                <span class="my-officer-name">{$AO.name}</span>
                <span class="officer-timer my-officer-timer"
                      id="my_timer_{$AO.id}"
                      data-seconds="{$AO.timeLeft}"></span>
            </div>
        {/if}
    {/foreach}

    {if !$hasActive}
        <div class="my-officer-empty">
            Şu anda aktif subayın yok.
        </div>
    {/if}
</div>


{foreach $officierList as $O}

<div class="officer-card" id="officer_card_{$O.id}">

    <div class="officer-top">
        <div class="officer-left">
            <img src="styles/theme/gow/img/officers/{$O.image}" class="officer-img">
        </div>

        <div class="officer-right">
            <div class="officer-name">
                {$O.name}

                {if $O.timeLeft > 0}
                    <span class="officer-timer" id="timer_{$O.id}" data-seconds="{$O.timeLeft}"></span>
                {else}
                    <span class="officer-timer timer-expired">Süre doldu</span>
                {/if}
            </div>

            <div class="officer-desc">{$O.description}</div>

            {if !empty($O.elementBonus)}
            <div class="officer-bonus">
                {foreach $O.elementBonus as $B}
                    <div class="bonus-line">
                        <span class="bonus-icon" data-key="{$B.key}"></span>
                        <span>
                            +{if $B.value < 1}{($B.value*100)|round}%{else}{$B.value}{/if}
                            {$BONUS_TRANSLATE[$B.key]|default:$B.key}
                        </span>
                    </div>
                {/foreach}
            </div>
            {/if}
        </div>
    </div>

    <div class="officer-pack-row">
        {foreach $O.packs as $P}
            <form action="game.php?page=officier" method="post" class="officer-pack-form">
                <input type="hidden" name="id" value="{$O.id}">
                <input type="hidden" name="days" value="{$P.days}">
                <button type="submit" class="officer-btn">
                    {$P.days} gün – {$P.cost|number} {$LNG.tech.921}
                </button>
            </form>
        {/foreach}
    </div>

</div>

{/foreach}



<script>
document.querySelectorAll('.officer-timer').forEach(function(el){
    let seconds = parseInt(el.dataset.seconds);

    function tick() {
        if (seconds <= 0) {
            el.classList.add("timer-expired");
            el.innerHTML = "Süre doldu";
            return;
        }

        if(seconds < 86400){
            el.classList.add("timer-warning");
        }

        let h = Math.floor(seconds / 3600);
        let m = Math.floor((seconds % 3600) / 60);
        let s = seconds % 60;

        el.innerHTML = h+":"+("0"+m).slice(-2)+":"+("0"+s).slice(-2);

        seconds--;
        setTimeout(tick, 1000);
    }

    tick();
});
</script>

{/block}
