<?php
/**
 * Basit dizin ağacı gösterici
 * Güvenlik için işin bitince bu dosyayı SİL.
 */

error_reporting(E_ALL);
ini_set('display_errors', 1);

// Başlangıç dizini: bu dosyanın bulunduğu klasör (public_html/steem/styles/templates/adm)
$root = __DIR__;

// Maksimum derinlik (çok uzamasın diye 4 yaptım, istersen 3 yapabilirsin)
$maxDepth = isset($_GET['depth']) ? (int)$_GET['depth'] : 4;

// Görünmesini istemediğimiz klasör isimleri
$ignore = ['.', '..', '.git', 'vendor', 'node_modules', 'logs', 'cache', 'sessions'];

/**
 * Dizin ağacını yazdır
 */
function listTree($dir, $prefix = '', $depth = 0, $maxDepth = 4, $ignore = [])
{
    if ($depth > $maxDepth) {
        return;
    }

    $items = @scandir($dir);
    if ($items === false) {
        return;
    }

    foreach ($items as $item) {
        if (in_array($item, $ignore, true)) {
            continue;
        }

        $path = $dir . DIRECTORY_SEPARATOR . $item;
        $isDir = is_dir($path);

        // girinti
        echo str_repeat('&nbsp;&nbsp;&nbsp;', $depth);

        // klasörse [D], dosyaysa [F] ile gösterelim
        echo $isDir ? '[D] ' : '[F] ';

        // kökten itibaren kısaltılmış yol
        echo htmlspecialchars(str_replace($GLOBALS['root'], '.', $path)) . "<br>\n";

        if ($isDir) {
            listTree($path, $prefix . '    ', $depth + 1, $maxDepth, $ignore);
        }
    }
}

?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <title>Klasör Ağacı - yeni</title>
    <style>
        body{
            background:#050710;
            color:#e5e7eb;
            font-family: Consolas, monospace;
            font-size:13px;
        }
        .box{
            max-width: 1100px;
            margin:20px auto;
            padding:15px;
            background:#0b1020;
            border:1px solid #283756;
            border-radius:8px;
        }
        h1{font-size:18px;margin-top:0;}
        .note{font-size:11px;color:#9ca3af;}
        a{color:#6ae1ff;text-decoration:none;}
    </style>
</head>
<body>
<div class="box">
    <h1>public_html/yeni/styles/templates Dizin Ağacı</h1>
    <div class="note">
        Maksimum derinlik: <?php echo (int)$maxDepth; ?> &nbsp;
        (<a href="?depth=3">3</a> | <a href="?depth=4">4</a> | <a href="?depth=5">5</a>)<br>
        İşin bitince <strong>tree.php</strong> dosyasını mutlaka silmeyi unut. 🔥
    </div>
    <hr>
    <pre style="white-space: pre-wrap;"><?php
        listTree($root, '', 0, $maxDepth, $ignore);
    ?></pre>
</div>
</body>
</html>
